/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.remote.internal;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBEndpoints;
import com.ibm.ws.ejbcontainer.jitdeploy.CORBA_Utils;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ejbcontainer.osgi.EJBStubClassGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.ejbcontainer.JITDeploy;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.omg.CORBA.Object;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class EJBStubClassGeneratorImpl
implements ClassGenerator,
ApplicationStateListener,
EJBStubClassGenerator {
    private static final TraceComponent tc = Tr.register(EJBStubClassGeneratorImpl.class);
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";
    private static final int RMIC_COMPATIBLE_ALL = -1;
    private final Map<ClassLoader, Set<Class<?>>> rmicCompatibleClassesByLoader = new WeakHashMap();
    private final Map<ApplicationInfo, Set<String>> rmicCompatibleClassNamesByApp = new WeakHashMap<ApplicationInfo, Set<String>>();
    static final long serialVersionUID = 5845329254859838772L;

    @Reference(service=LibertyProcess.class, target="(wlp.process.type=server)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    public byte[] generateClass(String name, ClassLoader loader) throws ClassNotFoundException {
        String remoteInterfaceName;
        if (!name.startsWith(ORG_OMG_STUB_PREFIX) && (remoteInterfaceName = JIT_Stub.getRemoteInterfaceName((String)name)) != null) {
            try {
                loader.loadClass(ORG_OMG_STUB_PREFIX + name);
            }
            catch (ClassNotFoundException e) {
                return this.generateStubClass(remoteInterfaceName, loader);
            }
        }
        return null;
    }

    @Sensitive
    @FFDCIgnore(value={ClassNotFoundException.class})
    private byte[] generateStubClass(String remoteInterfaceName, ClassLoader loader) {
        block4: {
            try {
                Class<?> remoteInterface = loader.loadClass(remoteInterfaceName);
                int rmicCompatible = this.isRMICCompatibleClass(remoteInterface, loader) ? -1 : JITDeploy.RMICCompatible;
                return JITDeploy.generateStubBytes(remoteInterface, (int)rmicCompatible);
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unable to load remote interface class: " + e), (java.lang.Object[])new java.lang.Object[0]);
                }
            }
            catch (EJBConfigurationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ejbcontainer.remote.internal.EJBStubClassGeneratorImpl", (String)"123", (java.lang.Object)this, (java.lang.Object[])new java.lang.Object[]{remoteInterfaceName, loader});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("failed to process " + remoteInterfaceName + " as a remote interface"), (java.lang.Object[])new java.lang.Object[]{e});
            }
        }
        return null;
    }

    private synchronized boolean isRMICCompatibleClass(Class<?> c, ClassLoader loader) {
        Set<Class<?>> rmicCompatibleClasses = this.rmicCompatibleClassesByLoader.get(loader);
        return rmicCompatibleClasses != null && rmicCompatibleClasses.contains(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRMICCompatibleClasses(String appName) {
        HashSet<String> rmicCompatibleClassNames = new HashSet<String>();
        Map<ApplicationInfo, Set<String>> map = this.rmicCompatibleClassNamesByApp;
        synchronized (map) {
            for (Map.Entry<ApplicationInfo, Set<String>> entry : this.rmicCompatibleClassNamesByApp.entrySet()) {
                if (!appName.equals(entry.getKey().getName())) continue;
                rmicCompatibleClassNames.addAll((Collection<String>)entry.getValue());
                break;
            }
        }
        return rmicCompatibleClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRMICCompatibleClasses(ClassLoader loader, Set<String> classesToAdd) {
        Map<ClassLoader, Set<Class<?>>> map = this.rmicCompatibleClassesByLoader;
        synchronized (map) {
            Set<Class<java.lang.Object>> rmicCompatibleClasses = this.rmicCompatibleClassesByLoader.get(loader);
            if (rmicCompatibleClasses == null) {
                rmicCompatibleClasses = Collections.newSetFromMap(new WeakHashMap());
                this.rmicCompatibleClassesByLoader.put(loader, rmicCompatibleClasses);
            }
            for (String rmicCompatibleClass : classesToAdd) {
                this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, loader, rmicCompatibleClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        NonPersistentCache appCache = EJBStubClassGeneratorImpl.getNonPersistentCache(appInfo.getContainer());
        ApplicationClassesContainerInfo appClassesContainerInfo = EJBStubClassGeneratorImpl.getFromCache(appCache, ApplicationClassesContainerInfo.class);
        if (appClassesContainerInfo != null) {
            HashSet appRmicCompatibleClasses = new HashSet();
            for (ModuleClassesContainerInfo moduleContainerInfo : appClassesContainerInfo.getModuleClassesContainerInfo()) {
                for (ContainerInfo containerInfo : moduleContainerInfo.getClassesContainerInfo()) {
                    Container container;
                    EJBEndpoints ejbEndpoints;
                    if (containerInfo.getType() != ContainerInfo.Type.EJB_MODULE || (ejbEndpoints = EJBStubClassGeneratorImpl.getEJBEndpoints(container = containerInfo.getContainer())) == null || ejbEndpoints.getModuleVersion() >= 30) continue;
                    NonPersistentCache moduleCache = EJBStubClassGeneratorImpl.getNonPersistentCache(container);
                    ModuleInfo moduleInfo = EJBStubClassGeneratorImpl.getFromCache(moduleCache, ModuleInfo.class);
                    ClassLoader loader = moduleInfo.getClassLoader();
                    Map<ClassLoader, Set<Class<?>>> map = this.rmicCompatibleClassesByLoader;
                    synchronized (map) {
                        Set<Class<java.lang.Object>> rmicCompatibleClasses = this.rmicCompatibleClassesByLoader.get(loader);
                        if (rmicCompatibleClasses == null) {
                            rmicCompatibleClasses = Collections.newSetFromMap(new WeakHashMap());
                            this.rmicCompatibleClassesByLoader.put(loader, rmicCompatibleClasses);
                        }
                        for (EJBEndpoint ejbEndpoint : ejbEndpoints.getEJBEndpoints()) {
                            this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, loader, ejbEndpoint.getHomeInterfaceName());
                            this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, loader, ejbEndpoint.getRemoteInterfaceName());
                        }
                        appRmicCompatibleClasses.addAll(rmicCompatibleClasses);
                    }
                }
            }
            if (appRmicCompatibleClasses.size() > 0) {
                HashSet<String> rmicCompatibleClassNames = new HashSet<String>(appRmicCompatibleClasses.size());
                for (Class clazz : appRmicCompatibleClasses) {
                    rmicCompatibleClassNames.add(clazz.getName());
                }
                Map<ApplicationInfo, Set<String>> map = this.rmicCompatibleClassNamesByApp;
                synchronized (map) {
                    this.rmicCompatibleClassNamesByApp.put(appInfo, rmicCompatibleClassNames);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static NonPersistentCache getNonPersistentCache(Container container) throws StateChangeException {
        try {
            return (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.ejbcontainer.remote.internal.EJBStubClassGeneratorImpl", (String)"228", null, (java.lang.Object[])new java.lang.Object[]{container});
            throw new StateChangeException((Throwable)e);
        }
    }

    @Trivial
    private static <T> T getFromCache(NonPersistentCache cache, Class<T> klass) {
        return (T)cache.getFromCache(klass);
    }

    /*
     * WARNING - void declaration
     */
    private static EJBEndpoints getEJBEndpoints(Container container) throws StateChangeException {
        try {
            return (EJBEndpoints)container.adapt(EJBEndpoints.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.ejbcontainer.remote.internal.EJBStubClassGeneratorImpl", (String)"242", null, (java.lang.Object[])new java.lang.Object[]{container});
            throw new StateChangeException((Throwable)e);
        }
    }

    private void addRMICCompatibleClassIfNeeded(@Sensitive Set<Class<?>> rmicCompatibleClasses, ClassLoader loader, String className) {
        if (className != null) {
            try {
                this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, loader.loadClass(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                java.lang.Object[] objectArray = new java.lang.Object[3];
                objectArray[0] = "<sensitive java.util.Set>";
                objectArray[1] = loader;
                objectArray[2] = className;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.ejbcontainer.remote.internal.EJBStubClassGeneratorImpl", (String)"251", (java.lang.Object)this, (java.lang.Object[])objectArray);
            }
        }
    }

    @Trivial
    private void addRMICCompatibleClassIfNeeded(Set<Class<?>> rmicCompatibleClasses, Class<?> c) {
        if (CORBA_Utils.isRemoteable(c, (int)-1) && c != Remote.class && c != Object.class && rmicCompatibleClasses.add(c)) {
            this.addReferencedRMICCompatibleClasses(rmicCompatibleClasses, c);
        }
    }

    private void addReferencedRMICCompatibleClasses(@Sensitive Set<Class<?>> rmicCompatibleClasses, Class<?> c) {
        for (Class<?> clazz : c.getInterfaces()) {
            this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, clazz);
        }
        for (GenericDeclaration genericDeclaration : c.getMethods()) {
            this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, ((Method)genericDeclaration).getReturnType());
            for (Class<?> paramType : ((Method)genericDeclaration).getParameterTypes()) {
                this.addRMICCompatibleClassIfNeeded(rmicCompatibleClasses, paramType);
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }
}

