/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.internal.resource.RequirementImpl;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Requirement;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.SelfExtractor;

public class ProductRequirement
extends RequirementImpl
implements Requirement {
    private final Map<String, String> directives;
    private final List<ProductRequirementInformation> productInformation;

    public ProductRequirement(VersionRange range) {
        super(range.toString());
        this.productInformation = Collections.singletonList(new ProductRequirementInformation(range.toString(), null, null, null, null));
        this.directives = this.createDirectives(range.toFilterString("version"));
    }

    private Map<String, String> createDirectives(String filter) {
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("filter", filter);
        return Collections.unmodifiableMap(directives);
    }

    public ProductRequirement(String appliesTo) {
        super(appliesTo);
        if (appliesTo == null || appliesTo.isEmpty()) {
            throw new InvalidParameterException("Applies to must be set to a valid value but is " + appliesTo);
        }
        StringBuilder filterString = new StringBuilder("(|");
        ArrayList<ProductRequirementInformation> products = new ArrayList<ProductRequirementInformation>();
        List matchers = SelfExtractor.parseAppliesTo((String)appliesTo);
        for (ProductMatch match : matchers) {
            String versionRange;
            filterString.append("(&");
            String productId = match.getProductId();
            this.appendAttributeEqualityCheck(filterString, "productId", productId);
            String version = match.getVersion();
            if (version != null && version.endsWith("+")) {
                versionRange = version.substring(0, version.length() - 1);
                this.appendAttributeCheck(filterString, "version", ">=", versionRange);
            } else {
                this.appendAttributeEqualityCheck(filterString, "version", version);
                versionRange = version != null ? Character.toString('[') + version + ", " + version + Character.toString(']') : null;
            }
            String installType = match.getInstallType();
            this.appendAttributeEqualityCheck(filterString, "installType", installType);
            String licenseType = match.getLicenseType();
            this.appendAttributeEqualityCheck(filterString, "licenseType", licenseType);
            List editions = match.getEditions();
            if (editions != null && !editions.isEmpty()) {
                filterString.append("(|");
                for (String edition : editions) {
                    this.appendAttributeEqualityCheck(filterString, "edition", edition);
                }
                filterString.append(")");
            }
            filterString.append(")");
            products.add(new ProductRequirementInformation(versionRange, productId, installType, licenseType, editions));
        }
        filterString.append(")");
        this.productInformation = products;
        this.directives = this.createDirectives(filterString.toString());
    }

    private void appendAttributeEqualityCheck(StringBuilder filterString, String attributeName, String value) {
        this.appendAttributeCheck(filterString, attributeName, "=", value);
    }

    private void appendAttributeCheck(StringBuilder filterString, String attributeName, String operator, String value) {
        if (value != null && !value.isEmpty()) {
            filterString.append("(").append(attributeName).append(operator).append(value).append(")");
        }
    }

    public String getNamespace() {
        return "com.ibm.ws.repo.product";
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public List<ProductRequirementInformation> getProductInformation() {
        return this.productInformation;
    }
}

