/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.processor.jms.service;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.AppDefinedResourceFactory;
import com.ibm.ws.jca.processor.jms.util.JMSResourceDefinitionHelper;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.resource.ResourceException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMSDestinationResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(JMSDestinationResourceFactoryBuilder.class);
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    static final String DECLARING_APPLICATION = "declaringApplication";
    static final String UNIQUE_JNDI_NAME = "jndiName.unique";
    private static final String ADMINISTERED_OBJECT_CLASS = "adminobject-class";
    private static final String BOOTSTRAP_CONTEXT = "bootstrapContext.target";
    private static final String CREATES_OBJECTCLASS = "creates.objectClass";
    private static final String RESOURCE_ADAPTER = "resourceAdapter";
    private static final String INTERFACE_NAME = "interfaceName";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private BundleContext bundleContext;
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    private final AtomicServiceReference<VariableRegistry> variableRegistryRef = new AtomicServiceReference("variableRegistry");
    private final AtomicServiceReference<MetaTypeService> metaTypeServiceRef = new AtomicServiceReference("metaTypeService");
    private final AtomicServiceReference<WSConfigurationHelper> wsConfigurationHelperRef = new AtomicServiceReference("wsConfigurationHelper");
    static final long serialVersionUID = 3043403769876323948L;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.configAdminRef.activate(context);
        this.variableRegistryRef.activate(context);
        this.metaTypeServiceRef.activate(context);
        this.wsConfigurationHelperRef.activate(context);
        this.bundleContext = context.getBundleContext();
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        AttributeDefinition[] ads;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{props});
        }
        Hashtable<String, Object> adminObjectSvcProps = new Hashtable<String, Object>();
        HashMap<String, Object> annotationDDProps = new HashMap<String, Object>();
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryRef.getServiceWithException();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (value instanceof String) {
                value = variableRegistry.resolveString((String)value);
            }
            annotationDDProps.put(prop.getKey(), value);
        }
        String application = (String)annotationDDProps.remove("application");
        String declaringApplication = (String)annotationDDProps.remove(DECLARING_APPLICATION);
        String module = (String)annotationDDProps.remove("module");
        String component = (String)annotationDDProps.remove("component");
        String jndiName = (String)annotationDDProps.remove("jndiName");
        annotationDDProps.remove(DESCRIPTION);
        annotationDDProps.remove(NAME);
        String adminObjectID = JMSDestinationResourceFactoryBuilder.getadminObjectID(application, module, component, jndiName);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)adminObjectID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(adminObjectID);
        }
        adminObjectSvcProps.put(ID, adminObjectID);
        adminObjectSvcProps.put(CONFIG_DISPLAY_ID, adminObjectID);
        adminObjectSvcProps.put(UNIQUE_JNDI_NAME, adminObjectID);
        adminObjectSvcProps.put("jndiName", jndiName);
        if (application != null) {
            adminObjectSvcProps.put("application", application);
            if (module != null) {
                adminObjectSvcProps.put("module", module);
                if (component != null) {
                    adminObjectSvcProps.put("component", component);
                }
            }
        }
        String resourceAdapter = (String)annotationDDProps.remove(RESOURCE_ADAPTER);
        String destinationName = (String)annotationDDProps.get("destinationName");
        String interfaceName = (String)annotationDDProps.remove(INTERFACE_NAME);
        if ("wasJms".equals(resourceAdapter)) {
            if ("javax.jms.Queue".equals(interfaceName)) {
                annotationDDProps.put("queueName", destinationName);
            } else if ("javax.jms.Topic".equals(interfaceName)) {
                annotationDDProps.put("topicName", destinationName);
            }
        } else if ("wmqJms".equals(resourceAdapter)) {
            if ("javax.jms.Queue".equals(interfaceName)) {
                annotationDDProps.put("baseQueueName", destinationName);
            } else if ("javax.jms.Topic".equals(interfaceName)) {
                annotationDDProps.put("baseTopicName", destinationName);
            }
        }
        Dictionary<String, Object> adminObjectDefaultProps = this.getDefaultProperties(resourceAdapter, interfaceName);
        Enumeration<String> keys = adminObjectDefaultProps.keys();
        while (keys.hasMoreElements()) {
            AttributeDefinition[] key = keys.nextElement();
            Object value = adminObjectDefaultProps.get(key);
            if (annotationDDProps.containsKey(key)) {
                value = annotationDDProps.remove(key);
            }
            if (value instanceof String) {
                value = variableRegistry.resolveString((String)value);
            }
            adminObjectSvcProps.put("properties.0." + (String)key, value);
        }
        for (AttributeDefinition attributeDefinition : ads = this.getAttributeDefinitions(resourceAdapter, interfaceName)) {
            Object value = annotationDDProps.remove(attributeDefinition.getID());
            if (value == null) continue;
            if (value instanceof String) {
                value = variableRegistry.resolveString((String)value);
            }
            adminObjectSvcProps.put("properties.0." + attributeDefinition.getID(), value);
        }
        adminObjectSvcProps.put(BOOTSTRAP_CONTEXT, "(id=" + resourceAdapter + ")");
        BundleContext bundleContext = FrameworkUtil.getBundle(AdminObjectService.class).getBundleContext();
        StringBuilder adminObjectFilter = new StringBuilder(200);
        adminObjectFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)adminObjectID));
        adminObjectFilter.append(FilterUtils.createPropertyFilter((String)"objectClass", (String)AdminObjectService.class.getName())).append(")");
        AppDefinedResourceFactory factory = new AppDefinedResourceFactory((ResourceFactoryBuilder)this, bundleContext, adminObjectID, adminObjectFilter.toString(), declaringApplication);
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration adminObjectSvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.adminObject.supertype", bundleLocation);
            adminObjectSvcConfig.update(adminObjectSvcProps);
        }
        catch (Exception bundleLocation) {
            void x;
            FFDCFilter.processException((Throwable)bundleLocation, (String)"com.ibm.ws.jca.processor.jms.service.JMSDestinationResourceFactoryBuilder", (String)"254", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.processor.jms.service.JMSDestinationResourceFactoryBuilder", (String)"257", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)factory);
        }
        return factory;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configAdminRef.deactivate(context);
        this.variableRegistryRef.deactivate(context);
        this.metaTypeServiceRef.deactivate(context);
        this.wsConfigurationHelperRef.deactivate(context);
    }

    private Dictionary<String, Object> getDefaultProperties(String resourceAdapter, String interfaceName) throws ConfigEvaluatorException, ResourceException {
        Bundle bundle = JMSResourceDefinitionHelper.getBundle(this.bundleContext, resourceAdapter);
        if (bundle != null) {
            String[] factoryPids;
            MetaTypeInformation metaTypeInformation = ((MetaTypeService)this.metaTypeServiceRef.getService()).getMetaTypeInformation(bundle);
            for (String factoryPid : factoryPids = metaTypeInformation.getFactoryPids()) {
                Dictionary defaultProps = ((WSConfigurationHelper)this.wsConfigurationHelperRef.getService()).getMetaTypeDefaultProperties(factoryPid);
                if (defaultProps.get(ADMINISTERED_OBJECT_CLASS) == null) continue;
                for (String createsClass : (String[])defaultProps.get(CREATES_OBJECTCLASS)) {
                    if (!createsClass.equals(interfaceName)) continue;
                    return defaultProps;
                }
            }
        }
        ResourceException x = new ResourceException();
        throw x;
    }

    private AttributeDefinition[] getAttributeDefinitions(String resourceAdapter, String interfaceName) throws ConfigEvaluatorException, ResourceException {
        Bundle bundle = JMSResourceDefinitionHelper.getBundle(this.bundleContext, resourceAdapter);
        if (bundle != null) {
            String[] factoryPids;
            MetaTypeInformation metaTypeInformation = ((MetaTypeService)this.metaTypeServiceRef.getService()).getMetaTypeInformation(bundle);
            for (String factoryPid : factoryPids = metaTypeInformation.getFactoryPids()) {
                Dictionary defaultProps = ((WSConfigurationHelper)this.wsConfigurationHelperRef.getService()).getMetaTypeDefaultProperties(factoryPid);
                if (defaultProps.get(ADMINISTERED_OBJECT_CLASS) == null) continue;
                for (String createsClass : (String[])defaultProps.get(CREATES_OBJECTCLASS)) {
                    if (!createsClass.equals(interfaceName)) continue;
                    ObjectClassDefinition ocd = metaTypeInformation.getObjectClassDefinition(factoryPid, null);
                    return ocd.getAttributeDefinitions(0);
                }
            }
        }
        ResourceException x = new ResourceException();
        throw x;
    }

    private static final String getadminObjectID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("adminObject").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
        if (existingConfigurations != null) {
            for (Configuration config : existingConfigurations) {
                Dictionary cfgProps = config.getProperties();
                if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                    }
                    return false;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
            }
        }
        return true;
    }

    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    protected void setVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.setReference(ref);
    }

    protected void unsetVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.unsetReference(ref);
    }

    protected void setWsConfigurationHelper(ServiceReference<WSConfigurationHelper> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setWSConfigurationHelper", (Object[])new Object[]{ref});
        }
        this.wsConfigurationHelperRef.setReference(ref);
    }

    protected void unsetWsConfigurationHelper(ServiceReference<WSConfigurationHelper> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.wsConfigurationHelperRef.unsetReference(ref);
    }

    protected void setMetaTypeService(ServiceReference<MetaTypeService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setMetaTypeService", (Object[])new Object[]{ref});
        }
        this.metaTypeServiceRef.setReference(ref);
    }

    protected void unsetMetaTypeService(ServiceReference<MetaTypeService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetMetaTypeService", (Object[])new Object[]{ref});
        }
        this.metaTypeServiceRef.unsetReference(ref);
    }
}

