/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.tai.extension;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.tai.extension.HTTPTrustAssociationInterceptor;
import com.ibm.websphere.security.tai.extension.SIPTrustAssociationInterceptor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BaseTrustAssociationInterceptor
implements TrustAssociationInterceptor {
    private boolean isHTTPTrustAssociationInterceptor = false;
    private boolean isSIPTrustAssociationInterceptor = false;
    static final long serialVersionUID = 139192896761595092L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BaseTrustAssociationInterceptor() {
        if (this instanceof HTTPTrustAssociationInterceptor) {
            this.isHTTPTrustAssociationInterceptor = true;
        }
        if (this instanceof SIPTrustAssociationInterceptor) {
            this.isSIPTrustAssociationInterceptor = true;
        }
    }

    public boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationFailedException {
        boolean result = false;
        if (this.isHTTPTrustAssociationInterceptor && req.getProtocol().startsWith("HTTP")) {
            HTTPTrustAssociationInterceptor inter = (HTTPTrustAssociationInterceptor)((Object)this);
            result = result || inter.isTargetProtocolInterceptor(req);
        } else if (this.isSIPTrustAssociationInterceptor && req.getProtocol().startsWith("SIP")) {
            SIPTrustAssociationInterceptor inter = (SIPTrustAssociationInterceptor)((Object)this);
            SipServletRequest sipReq = ThreadLocalStorage.getSipServletRequest();
            if (sipReq != null) {
                result = result || inter.isTargetProtocolInterceptor((SipServletMessage)sipReq);
            } else {
                SipServletResponse sipResp = ThreadLocalStorage.getSipServletResponse();
                if (sipResp != null) {
                    result = result || inter.isTargetProtocolInterceptor((SipServletMessage)sipResp);
                }
            }
        }
        return result;
    }

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException {
        TAIResult result = null;
        if (this.isSIPTrustAssociationInterceptor && req.getProtocol().startsWith("SIP")) {
            SIPTrustAssociationInterceptor inter = (SIPTrustAssociationInterceptor)((Object)this);
            SipServletRequest sipReq = ThreadLocalStorage.getSipServletRequest();
            SipServletResponse sipResp = ThreadLocalStorage.getSipServletResponse();
            result = inter.negotiateValidateandEstablishProtocolTrust(sipReq, sipResp);
        } else if (this.isHTTPTrustAssociationInterceptor && req.getProtocol().startsWith("HTTP")) {
            HTTPTrustAssociationInterceptor inter = (HTTPTrustAssociationInterceptor)((Object)this);
            result = inter.negotiateValidateandEstablishProtocolTrust(req, resp);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BaseTrustAssociationInterceptor.class, null, null);
    }
}

