/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpnegoTokenHelper {
    private static final TraceComponent tc;
    private static Oid KRB5_MECH_OID;
    private static Oid SPNEGO_MECH_OID;
    private static String USE_SUBJECT_CREDS_ONLY;
    static final long serialVersionUID = -876298743995782346L;

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromCallerSubject(final String spn, final int lifetime, final boolean delegate) throws WSSecurityException, GSSException, PrivilegedActionException {
        String token;
        SpnegoTokenHelper.checkSpn(spn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6063323207179772536L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws WSSecurityException, GSSException, PrivilegedActionException {
                    Subject subject = WSSubject.getCallerSubject();
                    if (subject == null) {
                        subject = WSSubject.getRunAsSubject();
                    }
                    String innerToken = SpnegoTokenHelper.buildSpnegoAuthorizationFromSubject(spn, subject, lifetime, delegate);
                    return innerToken;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"89", null, (Object[])new Object[]{spn, lifetime, delegate});
            Throwable general = SpnegoTokenHelper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof WSSecurityException) {
                throw (WSSecurityException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromNativeCreds(final String spn, final int lifetime, final boolean delegate) throws GSSException, PrivilegedActionException {
        SpnegoTokenHelper.checkSpn(spn);
        String token = null;
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -7778018494067749183L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws PrivilegedActionException, GSSException {
                    String token = null;
                    String savedProperty = System.setProperty(USE_SUBJECT_CREDS_ONLY, "false");
                    try {
                        GSSManager manager = SpnegoTokenHelper.getGSSManager();
                        GSSCredential gssCred = manager.createCredential(null, Integer.MAX_VALUE, KRB5_MECH_OID, 1);
                        gssCred.add(null, Integer.MAX_VALUE, Integer.MAX_VALUE, SPNEGO_MECH_OID, 1);
                        token = SpnegoTokenHelper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    }
                    finally {
                        if (savedProperty != null) {
                            System.setProperty(USE_SUBJECT_CREDS_ONLY, savedProperty);
                        } else {
                            System.clearProperty(USE_SUBJECT_CREDS_ONLY);
                        }
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"152", null, (Object[])new Object[]{spn, lifetime, delegate});
            Throwable general = SpnegoTokenHelper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromSubject(final String spn, final Subject subject, final int lifetime, final boolean delegate) throws GSSException, PrivilegedActionException {
        String token;
        SpnegoTokenHelper.checkSpn(spn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6934261862380400376L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws LoginException, GSSException, PrivilegedActionException {
                    GSSCredential gssCred = SubjectHelper.getGSSCredentialFromSubject((Subject)subject);
                    if (gssCred != null) {
                        GSSName name = gssCred.getName();
                        gssCred.add(name, lifetime, lifetime, SPNEGO_MECH_OID, 1);
                    }
                    String token = SpnegoTokenHelper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"200", null, (Object[])new Object[]{spn, subject, lifetime, delegate});
            Throwable general = SpnegoTokenHelper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUpn(final String spn, final String upn, final String jaasLoginContextEntry, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        SpnegoTokenHelper.checkSpn(spn);
        SpnegoTokenHelper.checkUpn(upn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6049386831730527339L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws LoginException, PrivilegedActionException, GSSException {
                    String savedProperty = System.setProperty(USE_SUBJECT_CREDS_ONLY, "false");
                    String token = null;
                    try {
                        String password = null;
                        LoginContext lc = new LoginContext(jaasLoginContextEntry, new WSCallbackHandlerImpl(upn, password));
                        lc.login();
                        Subject subject = lc.getSubject();
                        final GSSManager manager = SpnegoTokenHelper.getGSSManager();
                        GSSCredential gssCred = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){
                            static final long serialVersionUID = 1672932731472709421L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() throws GSSException, Exception {
                                GSSName gssName = manager.createName(upn, GSSName.NT_USER_NAME, KRB5_MECH_OID);
                                GSSCredential innerCred = manager.createCredential(gssName.canonicalize(KRB5_MECH_OID), lifetime, KRB5_MECH_OID, 1);
                                innerCred.add(gssName, lifetime, lifetime, SPNEGO_MECH_OID, 1);
                                return innerCred;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class);
                            }
                        });
                        token = SpnegoTokenHelper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    }
                    finally {
                        if (savedProperty != null) {
                            System.setProperty(USE_SUBJECT_CREDS_ONLY, savedProperty);
                        } else {
                            System.clearProperty(USE_SUBJECT_CREDS_ONLY);
                        }
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"281", null, (Object[])new Object[]{spn, upn, jaasLoginContextEntry, lifetime, delegate});
            Throwable general = SpnegoTokenHelper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUseridPassword(final String spn, final String userid, final @Sensitive String password, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        SpnegoTokenHelper.checkSpn(spn);
        SpnegoTokenHelper.checkUpn(userid);
        SpnegoTokenHelper.checkPassword(password);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -7461104122397513610L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws LoginException, GSSException, PrivilegedActionException {
                    LoginContext lc = null;
                    Subject subject = null;
                    String innerToken = null;
                    lc = new LoginContext("JAASClient", new WSCallbackHandlerImpl(userid, password));
                    lc.login();
                    subject = lc.getSubject();
                    GSSCredential gssCred = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = -4894529902949150252L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws GSSException, Exception {
                            GSSManager manager = SpnegoTokenHelper.getGSSManager();
                            GSSName gssName = manager.createName(userid, GSSName.NT_USER_NAME, KRB5_MECH_OID);
                            GSSCredential innerCred = manager.createCredential(gssName.canonicalize(KRB5_MECH_OID), lifetime, KRB5_MECH_OID, 1);
                            innerCred.add(gssName, lifetime, lifetime, SPNEGO_MECH_OID, 1);
                            return innerCred;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                    innerToken = SpnegoTokenHelper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    return innerToken;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            Object[] objectArray = new Object[5];
            objectArray[0] = spn;
            objectArray[1] = userid;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = lifetime;
            objectArray[4] = delegate;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"351", null, (Object[])objectArray);
            Throwable general = SpnegoTokenHelper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    private static String buildSpnegoAuthorization(GSSCredential gssCred, String spn, int lifetime, boolean delegate) throws GSSException {
        if (gssCred == null) {
            throw new GSSException(13);
        }
        SpnegoTokenHelper.checkSpn(spn);
        GSSManager manager = SpnegoTokenHelper.getGSSManager();
        GSSName backEnd = manager.createName(spn, GSSName.NT_USER_NAME);
        backEnd = backEnd.canonicalize(SPNEGO_MECH_OID);
        GSSContext context = manager.createContext(backEnd, SPNEGO_MECH_OID, gssCred, lifetime);
        context.requestMutualAuth(true);
        context.requestCredDeleg(delegate);
        byte[] response = null;
        int len = 0;
        byte[] request = context.initSecContext(response, 0, len);
        String token = "Negotiate " + Base64Coder.encode((byte[])request);
        context.dispose();
        return token;
    }

    private static void checkSpn(String spn) throws GSSException {
        if (spn == null || "".equals(spn)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty servicePrincipalName supplied", (Object[])new Object[0]);
            }
            throw new GSSException(3);
        }
    }

    private static void checkUpn(String upn) throws GSSException {
        if (upn == null || "".equals(upn)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty UserPrincipalName supplied", (Object[])new Object[0]);
            }
            throw new GSSException(3);
        }
    }

    private static void checkPassword(@Sensitive String password) throws GSSException {
        if (password == null || "".equals(password)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty password supplied", (Object[])new Object[0]);
            }
            throw new GSSException(13);
        }
    }

    private static GSSManager getGSSManager() throws GSSException {
        return GSSManager.getInstance();
    }

    private static Throwable getGeneralCause(PrivilegedActionException pae) {
        Throwable cause;
        Throwable retVal = pae;
        if (pae != null && (cause = pae.getCause()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deciphering a PrivilegedActionException [" + cause.getClass().getName() + "]"), (Object[])new Object[0]);
            }
            while (cause != null && cause instanceof PrivilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unravelling", (Object[])new Object[0]);
                }
                cause = cause.getCause();
            }
            if (cause != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unravelled to a " + cause.getClass().getName()), (Object[])new Object[0]);
                }
                retVal = cause;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Only PrivilegedActionException in stack.  Returning original exception.", (Object[])new Object[0]);
            }
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        block2: {
            tc = Tr.register(SpnegoTokenHelper.class);
            USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
            try {
                KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
                SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
            }
            catch (GSSException gSSException) {
                void ex;
                FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"486", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Unexpected GSSExecption: " + ex), (Object[])new Object[0]);
            }
        }
    }
}

