/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20MismatchedRedirectUriException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20MismatchedRedirectUriException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _receivedRedirectURI;
    private String _issuedToRedirectURI;

    public OAuth20MismatchedRedirectUriException(String receivedRedirectURI, String issuedToRedirectURI) {
        super("invalid_request", "The received redirect URI: " + receivedRedirectURI + " does not match the redirect URI the grant was issued to: " + issuedToRedirectURI, null);
        this._receivedRedirectURI = receivedRedirectURI;
        this._issuedToRedirectURI = issuedToRedirectURI;
    }

    public OAuth20MismatchedRedirectUriException(String msgKey, String receivedRedirectURI, String issuedToRedirectURI) {
        super("invalid_client", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{receivedRedirectURI, issuedToRedirectURI}), null);
        this._msgKey = msgKey;
        this._receivedRedirectURI = receivedRedirectURI;
        this._issuedToRedirectURI = issuedToRedirectURI;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._receivedRedirectURI, (Locale)locale, (String)encoding), this._issuedToRedirectURI);
    }

    public String getReceivedRedirectURI() {
        return this._receivedRedirectURI;
    }

    public String getIssuedToRedirectURI() {
        return this._issuedToRedirectURI;
    }
}

