/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelPlainFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.util.Locale;

public class HpelBasicFormatter
extends HpelPlainFormatter {
    private static final int svBasicFormatMaxNameLength = 13;
    private static final String svBasicPadding = "                                 ";
    private String svLineSeparatorPlusBasicPadding;
    private String svLineSeparatorPlusBasicPaddingPlusNullParamString;
    private static String[] specialLoggers = new String[]{"LogService"};
    private static String[] specialLoggerReplacement = new String[]{"osgiLog"};

    public HpelBasicFormatter() {
        this.svLineSeparatorPlusBasicPadding = this.lineSeparator + svBasicPadding;
        this.svLineSeparatorPlusBasicPaddingPlusNullParamString = this.svLineSeparatorPlusBasicPadding + "null";
    }

    @Override
    public String formatRecord(RepositoryLogRecord record, Locale locale) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        StringBuilder sb = new StringBuilder(300);
        String lineSeparatorPlusPadding = "";
        this.createEventHeader(record, sb);
        lineSeparatorPlusPadding = this.svLineSeparatorPlusBasicPadding;
        sb.append(this.formatMessage(record, locale));
        if (record.getStackTrace() != null) {
            sb.append(lineSeparatorPlusPadding);
            sb.append(record.getStackTrace());
        }
        return sb.toString();
    }

    @Override
    public String getFooter() {
        return "";
    }

    protected void createEventHeader(RepositoryLogRecord record, StringBuilder buffer) {
        int tmpLen;
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        this.createEventTimeStamp(record, buffer);
        HpelBasicFormatter.formatThreadID(record, buffer);
        String name = record.getLoggerName();
        boolean isSpecialLogger = false;
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < specialLoggers.length; ++i) {
            if (!name.trim().startsWith(specialLoggers[i])) continue;
            try {
                name = specialLoggerReplacement[i] + name.substring(name.indexOf("-"), name.indexOf("-", name.indexOf("-") + 1));
                isSpecialLogger = true;
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (!isSpecialLogger) {
            int index = name.lastIndexOf(46) + 1;
            name = index + 13 >= name.length() ? name.substring(index) : name.substring(index, index + 13);
        }
        buffer.append(name);
        for (int i = tmpLen = 13 - name.length(); i > 0; --i) {
            buffer.append(' ');
        }
        buffer.append(HpelBasicFormatter.mapLevelToType(record));
        String classname = record.getSourceClassName();
        String methodname = record.getSourceMethodName();
        if (classname != null) {
            buffer.append(classname);
        }
        buffer.append(' ');
        if (methodname != null) {
            buffer.append(methodname);
        }
        buffer.append(' ');
    }

    @Override
    protected String appendUnusedParms(String message, Object[] args) {
        String returnValue = message;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                buffer.append(this.svLineSeparatorPlusBasicPaddingPlusNullParamString);
                continue;
            }
            buffer.append(this.svLineSeparatorPlusBasicPadding);
            buffer.append(args[i].toString());
        }
        returnValue = returnValue.concat(buffer.toString());
        return returnValue;
    }

    @Override
    public void setLineSeparator(String lineSeparator) {
        super.setLineSeparator(lineSeparator);
        this.svLineSeparatorPlusBasicPadding = lineSeparator + svBasicPadding;
        this.svLineSeparatorPlusBasicPaddingPlusNullParamString = this.svLineSeparatorPlusBasicPadding + "null";
    }
}

