/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.InputStreamRequestBody;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.Validate;
import com.ibm.watson.developer_cloud.visual_recognition.v2.model.VisualClassification;
import com.ibm.watson.developer_cloud.visual_recognition.v2.model.VisualClassifier;
import com.ibm.watson.developer_cloud.visual_recognition.v2.model.VisualClassifiers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;

public class VisualRecognition
extends WatsonService {
    public static final String VERSION_DATE_2015_12_02 = "2015-12-02";
    private static final String POSITIVE_EXAMPLES = "positive_examples";
    private static final String NEGATIVE_EXAMPLES = "negative_examples";
    private static final String IMAGES_FILE = "images_file";
    private static final String NAME = "name";
    private static final String VERBOSE = "verbose";
    private static final String CLASSIFIER_IDS = "classifier_ids";
    private static final String PATH_CLASSIFIER = "/v2/classifiers/%s";
    private static final String PATH_CLASSIFIERS = "/v2/classifiers";
    private static final String PATH_CLASSIFY = "/v2/classify";
    private static final String URL = "https://gateway.watsonplatform.net/visual-recognition-beta/api";
    private String versionDate;

    public VisualRecognition(String versionDate) {
        super("visual_recognition");
        this.setEndPoint(URL);
        this.versionDate = versionDate;
    }

    public VisualClassification classify(File imagesFile) {
        return this.classify(imagesFile, new VisualClassifier[]{null});
    }

    public VisualClassification classify(File imagesFile, VisualClassifier ... classifiers) {
        Validate.isTrue(imagesFile != null && imagesFile.exists(), "image cannot be null or not be found");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(imagesFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.classify(imagesFile.getName(), stream, classifiers);
    }

    public VisualClassification classify(String filename, InputStream imagesInputStream, VisualClassifier ... classifiers) {
        Validate.notNull(imagesInputStream, "image cannot be null");
        Validate.notNull(filename, "filename cannot be null");
        MultipartBuilder bodyBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        bodyBuilder.addFormDataPart(IMAGES_FILE, filename, InputStreamRequestBody.create(HttpMediaType.BINARY_FILE, imagesInputStream));
        if (classifiers != null && classifiers.length > 0 && classifiers[0] != null) {
            JsonObject classifierIds = this.getClassifierIdsAsJson(classifiers);
            bodyBuilder.addFormDataPart(CLASSIFIER_IDS, classifierIds.toString());
        }
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_CLASSIFY).withQuery("version", this.versionDate).withBody(bodyBuilder.build());
        return this.executeRequest(requestBuilder.build(), VisualClassification.class);
    }

    private JsonObject getClassifierIdsAsJson(VisualClassifier ... classifiers) {
        JsonObject ret = new JsonObject();
        JsonArray array = new JsonArray();
        ret.add(CLASSIFIER_IDS, (JsonElement)array);
        for (VisualClassifier classifier : classifiers) {
            array.add((JsonElement)new JsonPrimitive(classifier.getId()));
        }
        return ret;
    }

    public VisualClassifier createClassifier(String name, File positiveImages, File negativeImages) {
        Validate.isTrue(positiveImages != null && positiveImages.exists(), "positiveImages cannot be null or not be found");
        Validate.isTrue(negativeImages != null && negativeImages.exists(), "negativeImages cannot be null or not be found");
        Validate.isTrue(name != null && !name.isEmpty(), "name cannot be null or empty");
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart(POSITIVE_EXAMPLES, positiveImages.getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)positiveImages)).addFormDataPart(NEGATIVE_EXAMPLES, negativeImages.getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)negativeImages)).addFormDataPart(NAME, name).build();
        Request request = RequestBuilder.post(PATH_CLASSIFIERS).withQuery("version", this.versionDate).withBody(body).build();
        return this.executeRequest(request, VisualClassifier.class);
    }

    public void deleteClassifier(String classifierId) {
        Validate.isTrue(classifierId != null && !classifierId.isEmpty(), "classifierId cannot be null or empty");
        Request request = RequestBuilder.delete(String.format(PATH_CLASSIFIER, classifierId)).withQuery("version", this.versionDate).build();
        this.executeWithoutResponse(request);
    }

    public VisualClassifier getClassifier(String classifierId) {
        Validate.isTrue(classifierId != null && !classifierId.isEmpty(), "classifierId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_CLASSIFIER, classifierId)).withQuery("version", this.versionDate).build();
        return this.executeRequest(request, VisualClassifier.class);
    }

    public List<VisualClassifier> getClassifiers() {
        Request request = RequestBuilder.get(PATH_CLASSIFIERS).withQuery("version", this.versionDate).withQuery(VERBOSE, true).build();
        VisualClassifiers classifiers = this.executeRequest(request, VisualClassifiers.class);
        return classifiers.getClassifiers();
    }
}

