/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.util;

import java.io.File;

public class MediaTypeUtils {
    private static String[] SUPPORTED_EXTENSION = new String[]{".wav", ".ogg", ".oga", ".flac", ".raw"};
    private static String[] SUPPORTED_MEDIA_TYPES = new String[]{"audio/wav", "audio/ogg; codecs=opus", "audio/ogg; codecs=opus", "audio/flac", "audio/l16"};

    public static String getMediaTypeFromFile(File file) {
        if (file != null) {
            String fileName = file.getName().toLowerCase();
            for (int i = 0; i < SUPPORTED_MEDIA_TYPES.length; ++i) {
                if (!fileName.endsWith(SUPPORTED_EXTENSION[i])) continue;
                return SUPPORTED_MEDIA_TYPES[i];
            }
        }
        return null;
    }

    public static Boolean isValidMediaType(String mediaType) {
        if (mediaType != null) {
            for (String supportedMediaType : SUPPORTED_MEDIA_TYPES) {
                if (!mediaType.equalsIgnoreCase(supportedMediaType)) continue;
                return true;
            }
        }
        return false;
    }
}

