/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graph;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validate;
import java.util.List;

public class Concept
extends GenericModel {
    @SerializedName(value="abstract")
    private String _abstract;
    private String id;
    private String label;
    private String link;
    private String name;
    private List<String> ontology;
    private String thumbnail;

    public Concept() {
    }

    public Concept(Graph graph, String concept) {
        Validate.notNull(graph, "graph cannot be null");
        Validate.notNull(graph.getId(), "graph.id cannot be null");
        this.setName(concept);
        this.setId(graph.getId() + "/concepts/" + concept);
    }

    public Concept(String accountId, String graphName, String concept) {
        Validate.notNull(concept, "concept cannot be null");
        this.setName(concept);
        this.setId(new Graph(accountId, graphName).getId() + "/concepts/" + concept);
    }

    public String getAbstract() {
        return this._abstract;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOntology() {
        return this.ontology;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setAbstract(String abs) {
        this._abstract = abs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOntology(List<String> ontology) {
        this.ontology = ontology;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }
}

