/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import java.util.Date;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.service.model.GenericModel;

/**
 * The Class DocumentProcessingState.
 */
public class DocumentProcessingStatus extends GenericModel {

  /** The last modified. */
  @SerializedName("last_modified")
  private Date lastModified;

  /** The status. */
  private String status;


  /**
   * Gets the last modified.
   * 
   * @return The lastModified
   */
  public Date getLastModified() {
    return lastModified;
  }

  /**
   * Gets the status.
   * 
   * @return The status
   */
  public String getStatus() {
    return status;
  }

  /**
   * Sets the last modified.
   * 
   * @param lastModified The last_modified
   */
  public void setLastModified(Date lastModified) {
    this.lastModified = lastModified;
  }

  /**
   * Sets the status.
   * 
   * @param status The status
   */
  public void setStatus(String status) {
    this.status = status;
  }

}
