/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath.xml;

import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XPathContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.drivers.XMLParserDriver;
import com.ibm.commons.xml.xpath.AbstractExpression;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.xml.Utils;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlComplexExpression
extends AbstractExpression {
    private XMLParserDriver domDriver;
    private Object compiledXPath;

    public XmlComplexExpression(XMLParserDriver domDriver, String expression, Object compiledXPath) {
        super(expression);
        this.domDriver = domDriver;
        this.compiledXPath = compiledXPath;
    }

    @Override
    public boolean supportsXPathContext() {
        return true;
    }

    @Override
    public void pushXPathContext(Object node) throws XPathException {
        try {
            Document document = this.getDocument(node);
            DOMUtil.pushXPathContext(document, this.getExpression());
        }
        catch (XMLException xe) {
            throw new XPathException((Throwable)((Object)xe));
        }
    }

    @Override
    public void popXPathContext(Object node) throws XPathException {
        try {
            Document document = this.getDocument(node);
            XPathContext context = DOMUtil.getXPathContext(document);
            if (context != null && context.getExpression().equals(this.getExpression())) {
                DOMUtil.popXPathContext(document);
            }
        }
        catch (XMLException xe) {
            throw new XPathException((Throwable)((Object)xe));
        }
    }

    @Override
    public NamespaceContext resolveNamespaceContext(Object node, NamespaceContext ns) {
        return Utils.resolveNamespaceContext((Node)node, ns);
    }

    @Override
    public boolean isValid(Object node) {
        return false;
    }

    public Object valueOf(Object node) {
        return node;
    }

    @Override
    public boolean isReadOnly(Object node) {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isFromRoot() {
        return this.getExpression().startsWith("/");
    }

    @Override
    protected XResult doEval(Object node, NamespaceContext namespaceContext) throws XPathException {
        Document document;
        XPathContext pathContext;
        if (node instanceof Document && (pathContext = DOMUtil.getXPathContext(document = (Document)node)) != null && (node = pathContext.getContextNodes()) == null) {
            try {
                pathContext.createNodes();
            }
            catch (XMLException xe) {
                throw new XPathException((Throwable)((Object)xe));
            }
            node = pathContext.getContextNodes();
        }
        if (node == null) {
            throw new XPathException(new NullPointerException("Cannot evaluate an XPath on a null object"));
        }
        if (node instanceof Node) {
            Node nodeObj = (Node)node;
            namespaceContext = this.resolveNamespaceContext(nodeObj, namespaceContext);
            return this.domDriver.evaluateXPath(nodeObj, this.compiledXPath, namespaceContext);
        }
        if (node instanceof NodeList) {
            NodeList nodeList = (NodeList)node;
            namespaceContext = this.resolveNamespaceContext(nodeList.item(0), namespaceContext);
            XResult r = this.domDriver.evaluateXPath(nodeList, this.compiledXPath, namespaceContext);
            return r;
        }
        throw new XPathException(null, "Try to evaluate an XPath on a object that is not a node or a node list");
    }

    @Override
    protected Object doCreateNodes(Object node, NamespaceContext namespaceContext) throws XPathException {
        throw new XPathException(null, "CREATE nodes not supported by complex expressions.");
    }

    @Override
    protected void doSetValue(Object node, Object value, NamespaceContext nsContext, boolean autoCreate) throws XPathException {
        if (node == null) {
            throw new XPathException(new NullPointerException("Cannot set a value on a null object"));
        }
        if (!(node instanceof Node)) {
            throw new XPathException(null, "Try to evaluate to set a value on a object that is not a node");
        }
        Node nodeObj = (Node)node;
        XResult r = this.domDriver.evaluateXPath(nodeObj, this.compiledXPath, nsContext = this.resolveNamespaceContext(nodeObj, nsContext));
        if (r.isEmpty()) {
            throw new XPathException(null, "Cannot create XPath {0}", this.getExpression());
        }
        if (r.isValue()) {
            throw new XPathException(null, "Cannot set a value on a value result, XPath={0}", this.getExpression());
        }
        String strValue = Utils.getAsString(value);
        Iterator it = r.getNodeIterator();
        while (it.hasNext()) {
            Object n = it.next();
            if (!(n instanceof Node)) continue;
            DOMUtil.setTextValue((Node)n, strValue);
        }
    }

    protected Document getDocument(Object node) throws XMLException {
        if (node instanceof Document) {
            return (Document)node;
        }
        return ((Node)node).getOwnerDocument();
    }
}

