/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.SystemCache;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.XPathExpression;
import com.ibm.commons.xml.xpath.XPathExpressionFactory;
import com.ibm.commons.xml.xpath.part.AttributePart;
import com.ibm.commons.xml.xpath.part.ElementPart;
import com.ibm.commons.xml.xpath.part.IndexedElementPart;
import com.ibm.commons.xml.xpath.part.Part;
import java.util.ArrayList;

public abstract class AbstractExpressionFactory
implements XPathExpressionFactory {
    protected SystemCache _expressionCache;
    public static final String FORBIDDEN_IN_CREATE = "()[]{}*=";
    public static final String FORBIDDEN_IN_SIMPLE = "(){}*=";

    public AbstractExpressionFactory() {
        this(null);
    }

    public AbstractExpressionFactory(String name) {
        this(name, 400);
    }

    public AbstractExpressionFactory(String name, int maxSize) {
        name = name == null ? this.getClass().getName() : name;
        this._expressionCache = new SystemCache(name, 400, "ibm.xpath.cachesize");
    }

    @Override
    public XPathExpression createExpression(Object data, String expression, boolean useCache) throws XPathException {
        XPathExpression pathExpression;
        if (useCache && (pathExpression = (XPathExpression)this._expressionCache.get(expression)) != null) {
            return pathExpression;
        }
        pathExpression = this.createSimpleExpression(expression);
        if (pathExpression == null) {
            pathExpression = this.createComplexExpression(expression);
        }
        if (useCache) {
            this.cacheExpression(expression, pathExpression);
        }
        return pathExpression;
    }

    protected XPathExpression createSimpleExpression(String expression) throws XPathException {
        if ("true".equals(expression)) {
            return null;
        }
        if ("false".equals(expression)) {
            return null;
        }
        char[] chars = expression.toCharArray();
        int index = 0;
        while (index < chars.length) {
            if (FORBIDDEN_IN_SIMPLE.indexOf(chars[index]) != -1) {
                return null;
            }
            ++index;
        }
        boolean isFromRoot = false;
        ArrayList<Part> partList = new ArrayList<Part>();
        int index2 = 0;
        while (index2 < chars.length) {
            if (index2 == 0) {
                if (chars[index2] == '/') {
                    isFromRoot = true;
                    if (chars.length > ++index2 && chars[index2] == '/') {
                        return null;
                    }
                }
            } else {
                if (chars[index2] != '/') {
                    return null;
                }
                ++index2;
            }
            if (index2 < chars.length && chars[index2] == '@') {
                int start = ++index2;
                if (index2 >= chars.length || !this.isXMLNameStartCharacter(chars[index2])) {
                    return null;
                }
                ++index2;
                while (index2 < chars.length && this.isXMLNameCharacter(chars[index2])) {
                    ++index2;
                }
                String attrName = new String(chars, start, index2 - start);
                AttributePart part = new AttributePart(attrName);
                partList.add(part);
                continue;
            }
            if (index2 < chars.length && this.isXMLNameStartCharacter(chars[index2])) {
                int start = index2++;
                while (index2 < chars.length && this.isXMLNameCharacter(chars[index2]) && chars[index2] != ':') {
                    ++index2;
                }
                String nsPrefix = null;
                String eltName = new String(chars, start, index2 - start);
                if (index2 < chars.length && chars[index2] == ':') {
                    nsPrefix = eltName;
                    start = ++index2;
                    if (index2 >= chars.length || !this.isXMLNameStartCharacter(chars[index2]) || chars[index2] == ':') {
                        return null;
                    }
                    ++index2;
                    while (index2 < chars.length && this.isXMLNameCharacter(chars[index2])) {
                        ++index2;
                    }
                    eltName = new String(chars, start, index2 - start);
                }
                if (index2 < chars.length && chars[index2] == '[') {
                    start = ++index2;
                    while (index2 < chars.length && chars[index2] != ']') {
                        ++index2;
                    }
                    String strIdx = new String(chars, start, index2 - start).trim();
                    if (StringUtil.isEmpty((String)strIdx)) {
                        return null;
                    }
                    ++index2;
                    try {
                        int idx = Integer.parseInt(strIdx);
                        IndexedElementPart part = new IndexedElementPart(nsPrefix, eltName, idx);
                        partList.add(part);
                        continue;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ElementPart part = new ElementPart(nsPrefix, eltName);
                partList.add(part);
                continue;
            }
            if (index2 < chars.length && chars[index2] == '.') {
                if (++index2 < chars.length && chars[index2] == '.') {
                    ++index2;
                    ElementPart part = new ElementPart(null, "..");
                    partList.add(part);
                    continue;
                }
                ElementPart part = new ElementPart(null, ".");
                partList.add(part);
                continue;
            }
            if (index2 >= chars.length) continue;
            return null;
        }
        Part[] parts = partList.toArray(new Part[partList.size()]);
        return this.createSimpleExpression(expression, isFromRoot, parts);
    }

    protected abstract XPathExpression createSimpleExpression(String var1, boolean var2, Part[] var3) throws XPathException;

    protected abstract XPathExpression createComplexExpression(String var1) throws XPathException;

    protected abstract boolean isXMLNameStartCharacter(char var1);

    protected abstract boolean isXMLNameCharacter(char var1);

    protected void cacheExpression(String expression, XPathExpression pathExpression) {
        if (pathExpression == null) {
            return;
        }
        this._expressionCache.put(expression, (Object)pathExpression);
    }
}

