/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.util;

public class DateStringParser {
    private String string;
    private int count;
    private int pointer;

    public DateStringParser(String s) {
        this.string = s;
        this.count = s.length();
    }

    public boolean isEOF() {
        return this.pointer >= this.count;
    }

    public int getCurrentPosition() {
        return this.pointer;
    }

    public boolean startsWith(char c) {
        if (this.pointer < this.count) {
            return this.string.charAt(this.pointer) == c;
        }
        return false;
    }

    public boolean match(char c) {
        if (this.startsWith(c)) {
            ++this.pointer;
            return true;
        }
        return false;
    }

    public int matchInteger(int len) {
        int ptr;
        if (this.pointer + len > this.count) {
            return Integer.MIN_VALUE;
        }
        int v = 0;
        for (ptr = this.pointer; ptr < this.pointer + len; ++ptr) {
            char c = this.string.charAt(ptr);
            if (Character.isDigit(c)) {
                v = v * 10 + (c - 48);
                continue;
            }
            return Integer.MIN_VALUE;
        }
        this.pointer = ptr;
        return v;
    }

    public int getNextInteger() {
        int ptr = this.pointer;
        boolean negate = false;
        if (ptr < this.count && this.string.charAt(ptr) == '-') {
            negate = true;
            ++ptr;
        }
        int v = 0;
        while (ptr < this.count) {
            char c = this.string.charAt(ptr);
            if (!Character.isDigit(c)) break;
            v = v * 10 + (c - 48);
            ++ptr;
        }
        if (ptr > this.pointer + (negate ? 1 : 0)) {
            this.pointer = ptr;
            return negate ? -v : v;
        }
        return Integer.MIN_VALUE;
    }
}

