/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.drivers;

import com.ibm.commons.util.io.NullInputStream;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.drivers.AbstractXercesDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesDriver
extends AbstractXercesDriver {
    private static final EntityResolver NULL_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
            return new InputSource((InputStream)new NullInputStream());
        }
    };

    @Override
    public Document parse(InputStream is, boolean ignoreBlanks, boolean resolveEntities, boolean validate) throws XMLException {
        try {
            DocumentBuilderFactory dbFactory = this.createDocumentBuilderFactory(resolveEntities, validate);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            if (!resolveEntities) {
                docBuilder.setEntityResolver(NULL_ENTITY_RESOLVER);
            }
            Document doc = docBuilder.parse(is);
            if (ignoreBlanks) {
                XercesDriver.removeEmtyTextNodes(doc);
            }
            return doc;
        }
        catch (Exception e) {
            throw new XMLException(e, "Error parsing XML stream");
        }
    }

    @Override
    public Document parse(Reader reader, boolean ignoreBlanks, boolean resolveEntities, boolean validate) throws XMLException {
        try {
            DocumentBuilderFactory dbFactory = this.createDocumentBuilderFactory(resolveEntities, validate);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            if (!resolveEntities) {
                docBuilder.setEntityResolver(NULL_ENTITY_RESOLVER);
            }
            Document doc = docBuilder.parse(new InputSource(reader));
            if (ignoreBlanks) {
                XercesDriver.removeEmtyTextNodes(doc);
            }
            return doc;
        }
        catch (Exception e) {
            throw new XMLException(e, "Error parsing XML stream");
        }
    }
}

