/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.drivers;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.Format;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.drivers.XMLParserDriver;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.xml.sax.InputSource;

public abstract class AbstractDriver
implements XMLParserDriver {
    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws XMLException {
        try {
            if (doctype != null && namespaceURI == null && qualifiedName == null) {
                Document doc = this.getDOMImplementation().createDocument(null, "ns", doctype);
                doc.removeChild(doc.getDocumentElement());
                return doc;
            }
            if (namespaceURI == null && qualifiedName == null) {
                return this.createDocument();
            }
            return this.getDOMImplementation().createDocument(namespaceURI, qualifiedName, doctype);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while creating new document");
        }
    }

    protected Document createDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws XMLException {
        try {
            return this.getDOMImplementation().createDocumentType(qualifiedName, publicId, systemId);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while parsing XML stream");
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(boolean resolveEntities, boolean validate) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setExpandEntityReferences(resolveEntities);
        dbFactory.setValidating(validate);
        return dbFactory;
    }

    @Override
    public Document parse(InputStream is, boolean resolveEntities, boolean ignoreBlanks, boolean validate) throws XMLException {
        try {
            DocumentBuilderFactory dbFactory = this.createDocumentBuilderFactory(resolveEntities, validate);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            if (ignoreBlanks) {
                AbstractDriver.removeEmtyTextNodes(doc);
            }
            return doc;
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while parsing XML stream");
        }
    }

    @Override
    public Document parse(Reader reader, boolean resolveEntities, boolean ignoreBlanks, boolean validate) throws XMLException {
        try {
            DocumentBuilderFactory dbFactory = this.createDocumentBuilderFactory(resolveEntities, validate);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(reader));
            if (ignoreBlanks) {
                AbstractDriver.removeEmtyTextNodes(doc);
            }
            return doc;
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while parsing XML stream");
        }
    }

    public static void removeEmtyTextNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        int i = length - 1;
        while (i >= 0) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 3) {
                Text txt = (Text)child;
                String data = txt.getData();
                if (StringUtil.isSpace((String)data)) {
                    node.removeChild(child);
                }
            } else {
                AbstractDriver.removeEmtyTextNodes(child);
            }
            --i;
        }
    }

    @Override
    public void serialize(OutputStream os, Node node, Format format) throws XMLException {
        StreamResult result = new StreamResult(os);
        this.serialize(node, result, format);
    }

    @Override
    public void serialize(Writer writer, Node node, Format format) throws XMLException {
        StreamResult result = new StreamResult(writer);
        this.serialize(node, result, format);
    }

    private void serialize(Node node, StreamResult result, Format format) throws XMLException {
        try {
            if (format == null) {
                format = Format.defaultFormat;
            }
            DOMSource domSource = new DOMSource(node);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", format.indent > 0 ? "yes" : "no");
            transformer.setOutputProperty("encoding", format.encoding);
            transformer.setOutputProperty("omit-xml-declaration", format.xmlDecl ? "no" : "yes");
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            throw new XMLException(e, "Error while converting XML document to string");
        }
    }

    @Override
    public DocumentTraversal getDocumentTraversal(Document doc) {
        return (DocumentTraversal)((Object)doc);
    }
}

