/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import com.ibm.commons.xml.DOMUtil;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class RangeIterator
implements ListIterator {
    private Node _currentNode;
    private int _currentOffset;
    private Node _commonAncestor;
    private Range _range;
    private Map _descentPath;
    private int _currentIndex;
    private boolean _firstChild;

    public RangeIterator(Range range) {
        this(range, false);
    }

    public RangeIterator(Range range, boolean firstChild) {
        if (range == null || range.getStartContainer() == null || range.getEndContainer() == null) {
            throw new NullPointerException();
        }
        this._range = range;
        this._firstChild = firstChild;
        this.initIterator();
    }

    @Override
    public boolean hasNext() {
        if (this._commonAncestor == null) {
            return false;
        }
        if (this._currentNode == null) {
            return true;
        }
        return !this.isAtEndOfRange(this._currentNode, this._currentOffset);
    }

    @Override
    public Object next() {
        if (this._commonAncestor == null) {
            throw new NoSuchElementException();
        }
        if (this._currentNode == null) {
            if (this._firstChild) {
                this._currentNode = this._range.getStartContainer();
                if (this._currentNode.hasChildNodes()) {
                    this._currentNode = this._currentNode.getChildNodes().item(this._range.getStartOffset());
                    this._currentOffset = 0;
                } else {
                    this._currentOffset = this._range.getStartOffset();
                }
            } else {
                this._currentNode = this._commonAncestor;
                this._currentOffset = (Integer)this._descentPath.get(this._commonAncestor);
            }
            ++this._currentIndex;
            return this._currentNode;
        }
        if (this.isAtEndOfRange(this._currentNode, this._currentOffset)) {
            throw new NoSuchElementException();
        }
        if (this._currentNode.hasChildNodes()) {
            Integer offsetInt = (Integer)this._descentPath.get(this._currentNode);
            if (offsetInt == null) {
                this._currentNode = this._currentNode.getFirstChild();
                ++this._currentIndex;
                this._currentOffset = 0;
                return this._currentNode;
            }
            Node tempNode = this._currentNode.getChildNodes().item(offsetInt);
            if (tempNode != null) {
                this._currentNode = tempNode;
                ++this._currentIndex;
                offsetInt = (Integer)this._descentPath.get(this._currentNode);
                this._currentOffset = offsetInt == null ? 0 : offsetInt;
                return this._currentNode;
            }
        }
        Node nextNode = this._currentNode.getNextSibling();
        ++this._currentOffset;
        while (nextNode == null) {
            this._currentNode = this._currentNode.getParentNode();
            if (this._currentNode == this._commonAncestor) {
                throw new NoSuchElementException();
            }
            nextNode = this._currentNode.getNextSibling();
            this._currentOffset = 0;
        }
        this._currentNode = nextNode;
        ++this._currentIndex;
        return this._currentNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initIterator() {
        this._currentIndex = 0;
        this._commonAncestor = this._range.getCommonAncestorContainer();
        if (this._commonAncestor == null) {
            return;
        }
        this._descentPath = new HashMap();
        Node node = this._range.getStartContainer();
        int offset = this._range.getStartOffset();
        Node ancestorParent = this._commonAncestor.getParentNode();
        while (node != ancestorParent) {
            this._descentPath.put(node, offset);
            offset = RangeIterator.getOffsetInContainer(node);
            node = node.getParentNode();
        }
    }

    public static int getOffsetInContainer(Node node) {
        Node parent = node.getParentNode();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child == node) {
                    return i;
                }
                ++i;
            }
            throw new IllegalStateException();
        }
        return -1;
    }

    public void add(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPrevious() {
        return this._currentIndex == 0;
    }

    @Override
    public int nextIndex() {
        return this._currentIndex + 1;
    }

    public Object previous() {
        if (this._currentIndex == 0) {
            throw new NoSuchElementException();
        }
        Node retNode = this._currentNode;
        Node prev = this._currentNode.getPreviousSibling();
        if (prev == null) {
            this._currentNode = this._currentNode.getParentNode();
        } else if (prev.hasChildNodes()) {
            NodeList children = prev.getChildNodes();
            this._currentNode = children.item(children.getLength() - 1);
        } else {
            this._currentNode = prev;
        }
        --this._currentIndex;
        return retNode;
    }

    @Override
    public int previousIndex() {
        return this._currentIndex - 1;
    }

    public void set(Object arg0) {
        throw new UnsupportedOperationException();
    }

    private boolean isAtEndOfRange(Node node, int offset) {
        if (node.getNodeType() == 3 && node == this._range.getEndContainer()) {
            return true;
        }
        int result = DOMUtil.compareLocations(node, offset, this._range.getEndContainer(), this._range.getEndOffset());
        if (result >= 0) {
            return true;
        }
        Node currentNode = node;
        Node endNode = this._range.getEndContainer();
        if (currentNode.hasChildNodes()) {
            return false;
        }
        Node parent = currentNode.getParentNode();
        while (parent != null) {
            NodeList children = parent.getChildNodes();
            if (children.item(children.getLength() - 1) != currentNode) break;
            if (parent == endNode) {
                return true;
            }
            currentNode = parent;
            parent = currentNode.getParentNode();
        }
        return false;
    }
}

