/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import com.ibm.commons.util.FilteredIterator;
import com.ibm.commons.util.IteratorWrapper;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.NamespaceContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NamespaceContextImpl
implements NamespaceContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Definition> definitions = new HashMap<String, Definition>();

    public void addNamespace(String prefix, String uri) {
        this.definitions.put(prefix, new Definition(prefix, uri));
    }

    public void remove(String prefix) {
        this.definitions.remove(prefix);
    }

    public void clear() {
        this.definitions.clear();
    }

    public void size() {
        this.definitions.size();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Definition def = this.definitions.get(prefix);
        return def != null ? def.uri : null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        for (Definition d : this.definitions.values()) {
            if (!StringUtil.equals((String)d.uri, (String)namespaceURI)) continue;
            return d.prefix;
        }
        return null;
    }

    @Override
    public Iterator getPrefixes(final String namespaceURI) {
        return new IteratorWrapper((Iterator)new FilteredIterator(this.definitions.values().iterator()){

            protected boolean accept(Object object) {
                Definition d = (Definition)object;
                return StringUtil.equals((String)d.uri, (String)namespaceURI);
            }
        }){

            protected Object wrap(Object o) {
                Definition d = (Definition)o;
                return d.prefix;
            }
        };
    }

    @Override
    public Iterator getPrefixes() {
        return this.definitions.keySet().iterator();
    }

    private static class Definition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String prefix;
        String uri;

        Definition(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

