/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import java.io.PrintStream;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class Dump {
    public static void dump(PrintStream ps, Node node) {
        Dump.dumpNodes(ps, node, new ArrayList());
    }

    private static void dumpNodes(PrintStream ps, Node node, ArrayList nodes) {
        int lv = 1;
        while (lv < nodes.size()) {
            Node parent = (Node)nodes.get(lv - 1);
            NodeList children = parent.getChildNodes();
            if (children.item(children.getLength() - 1) == nodes.get(lv)) {
                ps.print("    ");
            } else {
                ps.print("|   ");
            }
            ++lv;
        }
        nodes.add(node);
        try {
            if (nodes.size() > 1) {
                ps.print("+-");
            }
            switch (node.getNodeType()) {
                case 9: {
                    Document cfr_ignored_0 = (Document)node;
                    ps.print("DOCUMENT:");
                    break;
                }
                case 11: {
                    DocumentFragment cfr_ignored_1 = (DocumentFragment)node;
                    ps.print("DOCUMENT FRAGMENT:");
                    break;
                }
                case 10: {
                    DocumentType cfr_ignored_2 = (DocumentType)node;
                    ps.print("DOCUMENT TYPE:");
                    break;
                }
                case 1: {
                    Element v = (Element)node;
                    ps.print("ELEMENT:");
                    ps.print(" name='" + v.getTagName() + "'");
                    break;
                }
                case 2: {
                    Attr v = (Attr)node;
                    ps.print("ATTRIBUTE:");
                    ps.print(" name='" + v.getName() + "'");
                    ps.print(" value='" + v.getValue() + "'");
                    break;
                }
                case 4: {
                    CharacterData v = (CharacterData)node;
                    ps.print("CDATA:");
                    ps.print(" text='" + v.getData() + "'");
                    break;
                }
                case 3: {
                    Text v = (Text)node;
                    ps.print("TEXT:");
                    ps.print(" text='" + v.getData() + "'");
                    break;
                }
                case 8: {
                    Comment v = (Comment)node;
                    ps.print("COMMENT:");
                    ps.print(" text='" + v.getData() + "'");
                    break;
                }
                case 6: {
                    Entity cfr_ignored_3 = (Entity)node;
                    ps.print("ENTITY:");
                    break;
                }
                case 5: {
                    EntityReference cfr_ignored_4 = (EntityReference)node;
                    ps.print("ENTITY REFERENCE:");
                    break;
                }
                case 12: {
                    Notation cfr_ignored_5 = (Notation)node;
                    ps.print("NOTATION:");
                    break;
                }
                case 7: {
                    ProcessingInstruction cfr_ignored_6 = (ProcessingInstruction)node;
                    ps.print("PROCESSING INSTRUCTION:");
                }
            }
            NodeList children = node.getChildNodes();
            ps.print("\n");
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child != null) {
                    Dump.dumpNodes(ps, child, nodes);
                } else {
                    ps.print("<null node>\r\n");
                }
                ++i;
            }
        }
        finally {
            nodes.remove(nodes.size() - 1);
        }
    }
}

