/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.model.transform;

import com.ibm.cloud.objectstorage.services.s3.model.GetPublicAccessBlockResult;
import com.ibm.cloud.objectstorage.services.s3.model.PublicAccessBlockConfiguration;
import com.ibm.cloud.objectstorage.transform.SimpleTypeStaxUnmarshallers;
import com.ibm.cloud.objectstorage.transform.StaxUnmarshallerContext;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import com.ibm.cloud.objectstorage.util.XmlUtils;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;

public class GetPublicAccessBlockStaxUnmarshaller
implements Unmarshaller<GetPublicAccessBlockResult, InputStream> {
    private static final GetPublicAccessBlockStaxUnmarshaller instance = new GetPublicAccessBlockStaxUnmarshaller();

    public static GetPublicAccessBlockStaxUnmarshaller getInstance() {
        return instance;
    }

    private GetPublicAccessBlockStaxUnmarshaller() {
    }

    public GetPublicAccessBlockResult unmarshall(InputStream inputStream) throws Exception {
        StaxUnmarshallerContext context = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream));
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        GetPublicAccessBlockResult result = new GetPublicAccessBlockResult();
        PublicAccessBlockConfiguration configuration = new PublicAccessBlockConfiguration();
        result.setPublicAccessBlockConfiguration(configuration);
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return result;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BlockPublicAcls", targetDepth)) {
                    configuration.setBlockPublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                }
                if (!context.testExpression("IgnorePublicAcls", targetDepth)) continue;
                configuration.setIgnorePublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return result;
    }
}

