/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.HeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3XmlResponseHandler;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ResponseHeaderHandlerChain<T>
extends S3XmlResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> responseUnmarshaller, HeaderHandler<T> ... headerHandlers) {
        super(responseUnmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlers);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse awsResponse = super.handle(response);
        Object result = awsResponse.getResult();
        if (result != null) {
            for (HeaderHandler<Object> headerHandler : this.headerHandlers) {
                headerHandler.handle(result, response);
            }
        }
        return awsResponse;
    }
}

