/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.ion.impl;

import com.ibm.cloud.objectstorage.thirdparty.ion.SymbolTable;
import com.ibm.cloud.objectstorage.thirdparty.ion.SymbolToken;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.BaseSymbolTableWrapper;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.LocalSymbolTable;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.SymbolTokenImpl;

final class LocalSymbolTableImportAdapter
extends BaseSymbolTableWrapper {
    private final int systemSymbolCount = this.countSystemSymbols(this.getDelegate());

    static LocalSymbolTableImportAdapter of(LocalSymbolTable delegate) {
        LocalSymbolTable readOnlyDelegate;
        if (delegate.isReadOnly()) {
            readOnlyDelegate = delegate;
        } else {
            readOnlyDelegate = delegate.makeCopy();
            readOnlyDelegate.makeReadOnly();
        }
        return new LocalSymbolTableImportAdapter(readOnlyDelegate);
    }

    private LocalSymbolTableImportAdapter(LocalSymbolTable delegate) {
        super(delegate);
    }

    public SymbolTable getSystemSymbolTable() {
        return null;
    }

    public int getImportedMaxId() {
        return this.getDelegate().getImportedMaxId() - this.systemSymbolCount;
    }

    public int getMaxId() {
        return this.getDelegate().getMaxId() - this.systemSymbolCount;
    }

    public SymbolToken find(String text) {
        SymbolToken symbolToken = this.getDelegate().find(text);
        if (symbolToken != null) {
            symbolToken = new SymbolTokenImpl(symbolToken.getText(), symbolToken.getSid() - this.systemSymbolCount);
        }
        return symbolToken;
    }

    public int findSymbol(String name) {
        int sid = this.getDelegate().findSymbol(name);
        if (sid != -1) {
            sid -= this.systemSymbolCount;
        }
        return sid;
    }

    public String findKnownSymbol(int id) {
        return this.getDelegate().findKnownSymbol(id + this.systemSymbolCount);
    }

    private int countSystemSymbols(SymbolTable symbolTable) {
        SymbolTable systemSymbolTable = symbolTable.getSystemSymbolTable();
        if (systemSymbolTable != null) {
            return systemSymbolTable.getMaxId();
        }
        return 0;
    }
}

