/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.auth;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.Contract;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthScheme;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthSchemeFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthSchemeProvider;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.auth.KerberosScheme;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.params.HttpParams;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

