/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.waiters;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectMetadataRequest;
import com.ibm.cloud.objectstorage.services.s3.model.HeadBucketRequest;
import com.ibm.cloud.objectstorage.services.s3.model.HeadBucketResult;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.services.s3.waiters.HeadBucketFunction;
import com.ibm.cloud.objectstorage.services.s3.waiters.HeadObjectFunction;
import com.ibm.cloud.objectstorage.waiters.FixedDelayStrategy;
import com.ibm.cloud.objectstorage.waiters.HttpFailureStatusAcceptor;
import com.ibm.cloud.objectstorage.waiters.HttpSuccessStatusAcceptor;
import com.ibm.cloud.objectstorage.waiters.MaxAttemptsRetryStrategy;
import com.ibm.cloud.objectstorage.waiters.PollingStrategy;
import com.ibm.cloud.objectstorage.waiters.Waiter;
import com.ibm.cloud.objectstorage.waiters.WaiterBuilder;
import com.ibm.cloud.objectstorage.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

