/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.model.transform;

import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.AbstractS3ResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.model.HeadBucketResult;
import com.ibm.cloud.objectstorage.util.StringUtils;

public class HeadBucketResultHandler
extends AbstractS3ResponseHandler<HeadBucketResult> {
    @Override
    public AmazonWebServiceResponse<HeadBucketResult> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse<HeadBucketResult> awsResponse = new AmazonWebServiceResponse<HeadBucketResult>();
        HeadBucketResult result = new HeadBucketResult();
        result.setBucketRegion(response.getHeaders().get("x-amz-bucket-region"));
        if (!StringUtils.isNullOrEmpty(response.getHeaders().get("ibm-sse-kp-enabled"))) {
            result.setIBMSSEKPEnabled(Boolean.parseBoolean(response.getHeaders().get("ibm-sse-kp-enabled")));
        }
        if (!StringUtils.isNullOrEmpty(response.getHeaders().get("ibm-sse-kp-customer-root-key-crn"))) {
            result.setIBMSSEKPCrk(response.getHeaders().get("ibm-sse-kp-customer-root-key-crn"));
        }
        awsResponse.setResult(result);
        return awsResponse;
    }
}

