/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.HeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ObjectTransitionResult;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectTransitionHeaderHandler<T extends ObjectTransitionResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("date=\"(.*?)\"");
    private static final Pattern transitionPattern = Pattern.compile("transition=\"(.*?)\"");
    private static final Log log = LogFactory.getLog(ObjectTransitionHeaderHandler.class);

    @Override
    public void handle(T result, HttpResponse response) {
        String transitionHeader = response.getHeaders().get("x-ibm-transition");
        if (transitionHeader != null) {
            result.setTransitionDate(this.parseDate(transitionHeader));
            String transition = this.parseTransition(transitionHeader);
            if (transition != null) {
                result.setTransition(transition);
            }
        }
    }

    private Date parseDate(String restoreHeader) {
        Matcher matcher = datePattern.matcher(restoreHeader);
        if (matcher.find()) {
            String date = matcher.group(1);
            try {
                return ServiceUtils.parseRfc822Date(date);
            }
            catch (Exception exception) {
                log.warn("Error parsing date from x-ibm-transition header.", exception);
            }
        }
        return null;
    }

    private String parseTransition(String restoreHeader) {
        Matcher matcher = transitionPattern.matcher(restoreHeader);
        if (matcher.find()) {
            String transition = matcher.group(1);
            return transition;
        }
        return null;
    }
}

