/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.ibm.aspera.faspmanager2.ITransferListener;
import com.ibm.cloud.objectstorage.event.SDKProgressPublisher;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaFaspManagerWrapper;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TransferListener
extends ITransferListener {
    final Map<String, Long> transactionCallbackTime;
    final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    final Map<String, String> status;
    final Map<String, List<String>> transactionSessions;
    final Map<String, Long> bytesTransferred;
    final Map<String, Long> totalPreTransferBytes;
    final Map<String, Map<String, Long>> sessionsBytesTransferred;
    private static final Map<String, List<AsperaTransaction>> transactions = new ConcurrentHashMap<String, List<AsperaTransaction>>();
    private static TransferListener instance = null;
    protected Log log = LogFactory.getLog(AsperaFaspManagerWrapper.class);
    private static int ascpCount;

    protected TransferListener() {
        this.status = new ConcurrentHashMap<String, String>();
        this.transactionSessions = new ConcurrentHashMap<String, List<String>>();
        this.bytesTransferred = new ConcurrentHashMap<String, Long>();
        this.totalPreTransferBytes = new ConcurrentHashMap<String, Long>();
        this.sessionsBytesTransferred = new ConcurrentHashMap<String, Map<String, Long>>();
        this.transactionCallbackTime = new ConcurrentHashMap<String, Long>();
        this.startScheduler();
        ascpCount = 0;
    }

    public static TransferListener getInstance(String xferId, AsperaTransaction transaction) {
        if (instance == null) {
            instance = new TransferListener();
        }
        if (transactions.get(xferId) != null) {
            transactions.get(xferId).add(transaction);
        } else {
            ArrayList<AsperaTransaction> transferTransactions = new ArrayList<AsperaTransaction>();
            transferTransactions.add(transaction);
            transactions.put(xferId, transferTransactions);
        }
        return instance;
    }

    public synchronized void transferReporter(String xferId, String msg) {
        String[] keyValPairs;
        this.transactionCallbackTime.put(xferId, System.currentTimeMillis());
        this.log.debug("TransferListener >>  transferReporter: msg= " + msg);
        this.log.trace("TransferListener.transferReporter >> " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
        HashMap<String, String> msgStats = new HashMap<String, String>();
        for (String keyVal : keyValPairs = msg.split("\n")) {
            String[] arr = keyVal.split(":");
            if (arr.length != 2) continue;
            msgStats.put(arr[0].trim(), arr[1].trim());
        }
        String type = (String)msgStats.get("Type");
        AsperaTransaction.AsperaTransactionState transState = AsperaTransaction.AsperaTransactionState.valueOf(type);
        String sessionId = (String)msgStats.get("SessionId");
        if (msgStats.get("PreTransferBytes") != null && transState == AsperaTransaction.AsperaTransactionState.NOTIFICATION) {
            Long oldPreTransferBytes = this.totalPreTransferBytes.get(xferId);
            Long newPreTransferByteTotal = 0L;
            long preTransferBytes = 0L;
            try {
                preTransferBytes = Long.parseLong((String)msgStats.get("PreTransferBytes"));
            }
            catch (NumberFormatException e) {
                preTransferBytes = 0L;
            }
            if (oldPreTransferBytes == null) {
                this.totalPreTransferBytes.put(xferId, preTransferBytes);
                newPreTransferByteTotal = preTransferBytes;
            } else {
                newPreTransferByteTotal = oldPreTransferBytes + preTransferBytes;
                this.totalPreTransferBytes.put(xferId, newPreTransferByteTotal);
            }
            this.setTotalBytesToTransfer(xferId, newPreTransferByteTotal);
        }
        long bytes = 0L;
        if (msgStats.get("FileBytes") != null && (transState == AsperaTransaction.AsperaTransactionState.STATS || transState == AsperaTransaction.AsperaTransactionState.STOP || transState == AsperaTransaction.AsperaTransactionState.DONE)) {
            try {
                bytes = Long.parseLong((String)msgStats.get("FileBytes"));
            }
            catch (NumberFormatException e) {
                bytes = 0L;
            }
            Map<String, Long> sessionBytesTransferred = this.sessionsBytesTransferred.get(xferId);
            if (sessionBytesTransferred == null) {
                sessionBytesTransferred = new ConcurrentHashMap<String, Long>();
                sessionBytesTransferred.put(sessionId, 0L);
                this.sessionsBytesTransferred.put(xferId, sessionBytesTransferred);
            }
        }
        this.setStatus(xferId, sessionId, type, bytes);
        this.log.trace("TransferListener.transferReporter << " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
    }

    private void setTotalBytesToTransfer(String xferId, Long preTransferBytes) {
        for (AsperaTransaction transaction : transactions.get(xferId)) {
            if (transaction.getProgress() == null) continue;
            transaction.getProgress().setTotalBytesToTransfer(preTransferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus(String xferId) {
        TransferListener transferListener = this;
        synchronized (transferListener) {
            return this.status.get(xferId);
        }
    }

    public synchronized void setStatus(String xferId, String sessionId, String status, long bytes) {
        this.log.trace("TransferListener.setStatus >> " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
        if (status.equals("INIT") && this.isNewSession(xferId, sessionId)) {
            ++ascpCount;
        } else if (status.equals("DONE") || status.equals("STOP") || status.equals("ARGSTOP")) {
            this.removeTransactionSession(xferId, sessionId);
            this.removeTransactionFromAudit(xferId);
        } else if (status.equals("ERROR")) {
            this.log.error("Status marked as [ERROR] for xferId [" + xferId + "]");
            ascpCount -= this.numberOfSessionsInTransaction(xferId);
            this.removeAllTransactionSessions(xferId);
            this.removeTransactionProgressData(xferId);
            this.removeTransactionFromAudit(xferId);
        }
        if (status.equals("ARGSTOP")) {
            this.removeTransactionFromAudit(xferId);
            this.removeAllTransactionSessions(xferId);
        }
        if (bytes > 0L) {
            this.updateProgress(xferId, sessionId, status, bytes);
        }
        if (status.equals("DONE") || status.equals("STOP")) {
            if (this.totalPreTransferBytes.get(xferId) == null || this.bytesTransferred.get(xferId) != null && this.bytesTransferred.get(xferId) >= this.totalPreTransferBytes.get(xferId)) {
                this.status.put(xferId, status);
                this.removeTransactionProgressData(xferId);
                this.removeTransactionFromAudit(xferId);
                this.log.info("Status marked as [" + status + "] for xferId [" + xferId + "]");
            }
        } else {
            this.status.put(xferId, status);
        }
        this.log.trace("TransferListener.setStatus << " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
    }

    private void removeTransactionProgressData(String xferId) {
        transactions.remove(xferId);
    }

    private void removeTransactionFromAudit(String xferId) {
        this.transactionCallbackTime.remove(xferId);
    }

    public static int getAscpCount() {
        return ascpCount;
    }

    private synchronized void updateProgress(String xferId, String sessionId, String status, long bytes) {
        AsperaTransaction.AsperaTransactionState transState;
        Map<String, Long> sessionBytesTransferred;
        Long currentBytesTransferredForSession;
        this.log.trace("TransferListener.updateProgress >> " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
        Long totalBytesTransferred = this.bytesTransferred.get(xferId);
        if (totalBytesTransferred == null) {
            totalBytesTransferred = new Long(0L);
        }
        if ((currentBytesTransferredForSession = (sessionBytesTransferred = this.sessionsBytesTransferred.get(xferId)).get(sessionId)) == null) {
            currentBytesTransferredForSession = 0L;
            sessionBytesTransferred.put(sessionId, currentBytesTransferredForSession);
        }
        long chunkBytes = bytes - currentBytesTransferredForSession;
        sessionBytesTransferred.put(sessionId, bytes);
        this.bytesTransferred.put(xferId, totalBytesTransferred + chunkBytes);
        try {
            transState = AsperaTransaction.AsperaTransactionState.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            transState = null;
        }
        switch (transState) {
            case STATS: {
                this.fireProgressEvent(xferId, chunkBytes);
                break;
            }
            case DONE: {
                this.fireProgressEvent(xferId, chunkBytes);
                break;
            }
            case STOP: {
                this.fireProgressEvent(xferId, chunkBytes);
                break;
            }
        }
        this.log.trace("TransferListener.updateProgress << " + System.nanoTime() + ": " + new Exception().getStackTrace()[1].getClassName());
    }

    protected void fireProgressEvent(String xferid, long bytesTransferred) {
        this.log.trace("TransferListener.fireProgressEvent >> " + System.nanoTime());
        if (transactions.get(xferid) == null) {
            return;
        }
        for (AsperaTransaction transaction : transactions.get(xferid)) {
            SDKProgressPublisher.publishRequestBytesTransferred(transaction.getProgressListenerChain(), bytesTransferred);
        }
        this.log.trace("TransferListener.fireProgressEvent << " + System.nanoTime());
    }

    public void removeTransaction(String xferid) {
        this.log.debug("TransferListener >> removeTransaction: " + xferid);
        this.status.remove(xferid);
        this.bytesTransferred.remove(xferid);
        this.totalPreTransferBytes.remove(xferid);
        this.sessionsBytesTransferred.remove(xferid);
    }

    private boolean isNewSession(String xferId, String sessionId) {
        List<String> currentSessions = this.transactionSessions.get(xferId);
        if (currentSessions == null) {
            ArrayList<String> sessions = new ArrayList<String>();
            sessions.add(sessionId);
            this.transactionSessions.put(xferId, sessions);
            return true;
        }
        if (!currentSessions.contains(sessionId)) {
            currentSessions.add(sessionId);
            return true;
        }
        return false;
    }

    private void removeTransactionSession(String xferId, String sessionId) {
        boolean removal;
        List<String> sessions = this.transactionSessions.get(xferId);
        if (sessions != null && (removal = sessions.remove(sessionId))) {
            --ascpCount;
        }
    }

    public void removeAllTransactionSessions(String xferId) {
        List<String> sessions = this.transactionSessions.get(xferId);
        if (sessions != null) {
            sessions.clear();
        }
    }

    private int numberOfSessionsInTransaction(String xferId) {
        int sessionCount = 0;
        List<String> sessions = this.transactionSessions.get(xferId);
        if (sessions != null) {
            sessionCount = sessions.size();
        }
        return sessionCount;
    }

    private void startScheduler() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Iterator<Map.Entry<String, Long>> it = TransferListener.this.transactionCallbackTime.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Long> pair = it.next();
                    if (System.currentTimeMillis() - pair.getValue() <= 5000L) continue;
                    String xferId = pair.getKey();
                    it.remove();
                    TransferListener.this.status.put(xferId, "ERROR");
                    ascpCount = ascpCount - TransferListener.this.numberOfSessionsInTransaction(xferId);
                    TransferListener.this.removeAllTransactionSessions(xferId);
                    TransferListener.this.removeTransactionProgressData(xferId);
                    TransferListener.this.log.error("Status marked as [ERROR] for xferId [" + xferId + "] after not reporting for over 5 seconds");
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public void shutdownThreadPools() {
        this.scheduledExecutorService.shutdown();
    }

    protected void finalize() {
        this.shutdownThreadPools();
    }
}

