/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.ibm.aspera.faspmanager2.ITransferListener;
import com.ibm.aspera.faspmanager2.faspmanager2;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaLibraryLoader;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaTransferManagerUtils;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;

public class AsperaFaspManagerWrapper {
    private AsperaTransaction asperaTransaction;
    protected Log log = LogFactory.getLog(AsperaFaspManagerWrapper.class);

    public AsperaFaspManagerWrapper() {
    }

    public AsperaFaspManagerWrapper(AsperaTransaction asperaTransaction) {
        this.asperaTransaction = asperaTransaction;
    }

    public long startTransfer(String xferId, String transferSpecStr) {
        this.log.info("Starting transfer with xferId [" + xferId + "]");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transfer Spec for Session with xferId [" + xferId + "]");
            this.log.debug(AsperaTransferManagerUtils.getRedactedJsonString(transferSpecStr, "token"));
        }
        this.log.trace("Calling method [startTransfer] with parameters [\"" + xferId + "\", null, transferSpecStr, transferListener]");
        long rtn = faspmanager2.startTransfer((String)xferId, null, (String)transferSpecStr, (ITransferListener)this.asperaTransaction.getTransferListener());
        this.log.trace("Method [startTransfer] returned for xferId [\"" + xferId + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public boolean pause(String xferId) {
        this.log.info("Pausing transfer with xferId [" + xferId + "]");
        this.log.trace("Calling method [modifyTransfer] with parameters [\"" + xferId + "\", 4, 0]");
        boolean rtn = faspmanager2.modifyTransfer((String)xferId, (int)4, (long)0L);
        this.log.trace("Method [modifyTransfer] returned for xferId [\"" + xferId + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public boolean resume(String xferId) {
        this.log.info("Resuming transfer with xferId [" + xferId + "]");
        this.log.trace("Calling method [modifyTransfer] with parameters [\"" + xferId + "\", 5, 0]");
        boolean rtn = faspmanager2.modifyTransfer((String)xferId, (int)5, (long)0L);
        this.log.trace("Method [modifyTransfer] returned for xferId [\"" + xferId + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public boolean cancel(String xferId) {
        this.log.info("Cancel transfer with xferId [" + xferId + "]");
        this.log.trace("Calling method [stopTransfer] with parameters [\"" + xferId + "\", 8, 0]");
        boolean rtn = faspmanager2.stopTransfer((String)xferId);
        this.log.trace("Method [stopTransfer] returned for xferId [\"" + xferId + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public boolean isRunning(String xferId) {
        this.log.trace("Calling method [isRunning] with parameters [\"" + xferId + "\"]");
        boolean rtn = faspmanager2.isRunning((String)xferId);
        this.log.trace("Method [isRunning] returned for xferId [\"" + xferId + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public boolean configureLogLocation(String ascpLogPath) {
        this.log.trace("Calling method [configureLogLocation] with parameters [\"" + ascpLogPath + "\"]");
        boolean rtn = faspmanager2.configureLogLocation((String)ascpLogPath);
        this.log.trace("Method [configureLogLocation] returned for ascpLogPath [\"" + ascpLogPath + "\"] with result: [" + rtn + "]");
        return rtn;
    }

    public void setAsperaTransaction(AsperaTransaction asperaTransaction) {
        this.asperaTransaction = asperaTransaction;
    }

    static {
        String location = AsperaLibraryLoader.load();
        faspmanager2.configureAsperaLocation((String)location);
        faspmanager2.configureLogLocation((String)location);
    }
}

