/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.oauth;

import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.SignableRequest;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSSessionCredentials;
import com.ibm.cloud.objectstorage.auth.AbstractAWSSigner;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.IBMOAuthCredentials;

public class IBMOAuthSigner
extends AbstractAWSSigner {
    protected static final InternalLogApi log = InternalLogFactory.getLog(IBMOAuthSigner.class);
    private ClientConfiguration clientConfiguration;

    public IBMOAuthSigner(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public IBMOAuthSigner() {
    }

    @Override
    public void sign(SignableRequest<?> request, AWSCredentials credentials) {
        log.debug("++ OAuth signer");
        IBMOAuthCredentials oAuthCreds = (IBMOAuthCredentials)credentials;
        if (oAuthCreds.getTokenManager() instanceof DefaultTokenManager) {
            DefaultTokenManager tokenManager = (DefaultTokenManager)oAuthCreds.getTokenManager();
            tokenManager.setClientConfiguration(this.clientConfiguration);
            request.addHeader("Authorization", "Bearer " + tokenManager.getToken());
        } else {
            request.addHeader("Authorization", "Bearer " + oAuthCreds.getTokenManager().getToken());
        }
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> request, AWSSessionCredentials credentials) {
    }
}

