/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class GetSchedulerDocsOptions
extends GenericModel {
    protected Long limit;
    protected Long skip;
    protected List<String> states;

    protected GetSchedulerDocsOptions() {
    }

    protected GetSchedulerDocsOptions(Builder builder) {
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.states = builder.states;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long limit() {
        return this.limit;
    }

    public Long skip() {
        return this.skip;
    }

    public List<String> states() {
        return this.states;
    }

    public static class Builder {
        private Long limit;
        private Long skip;
        private List<String> states;

        private Builder(GetSchedulerDocsOptions getSchedulerDocsOptions) {
            this.limit = getSchedulerDocsOptions.limit;
            this.skip = getSchedulerDocsOptions.skip;
            this.states = getSchedulerDocsOptions.states;
        }

        public Builder() {
        }

        public GetSchedulerDocsOptions build() {
            return new GetSchedulerDocsOptions(this);
        }

        public Builder addStates(String states) {
            Validator.notNull((Object)states, (String)"states cannot be null");
            if (this.states == null) {
                this.states = new ArrayList<String>();
            }
            this.states.add(states);
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = states;
            return this;
        }
    }

    public static interface States {
        public static final String INITIALIZING = "initializing";
        public static final String ERROR = "error";
        public static final String PENDING = "pending";
        public static final String RUNNING = "running";
        public static final String CRASHING = "crashing";
        public static final String COMPLETED = "completed";
        public static final String FAILED = "failed";
    }
}

