/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features;

import com.ibm.cloud.cloudant.features.ChangesOptionsHelper;
import com.ibm.cloud.cloudant.features.ChangesResultSpliterator;
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.ChangesResultItem;
import com.ibm.cloud.cloudant.v1.model.DatabaseInformation;
import com.ibm.cloud.cloudant.v1.model.GetDatabaseInformationOptions;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ChangesFollower {
    static final Long BATCH_SIZE = 10000L;
    private static final Logger LOGGER = Logger.getLogger(ChangesFollower.class.getName());
    private final Cloudant client;
    private final PostChangesOptions options;
    private final Duration errorTolerance;
    private final Long limit;
    private AtomicReference<ChangesResultSpliterator> changesResultSpliterator = new AtomicReference();

    public ChangesFollower(Cloudant client, PostChangesOptions options) throws IllegalArgumentException {
        this(client, options, ChronoUnit.FOREVER.getDuration());
    }

    public ChangesFollower(Cloudant client, PostChangesOptions options, Duration errorTolerance) throws IllegalArgumentException {
        ChangesOptionsHelper.validateOptions(options);
        this.limit = options.limit();
        this.options = ChangesOptionsHelper.cloneOptions(options);
        this.client = client;
        if (errorTolerance.isNegative()) {
            throw new IllegalArgumentException("Error tolerance duration must not be negative.");
        }
        this.errorTolerance = errorTolerance;
        long callTimeout = this.client.getClient().callTimeoutMillis();
        long readTimeout = this.client.getClient().readTimeoutMillis();
        if (callTimeout > 0L && callTimeout < ChangesOptionsHelper.MIN_CLIENT_TIMEOUT || readTimeout > 0L && readTimeout < ChangesOptionsHelper.MIN_CLIENT_TIMEOUT) {
            throw new IllegalArgumentException(String.format("To use %s the client read and call timeouts must be at least %d ms. The client read timeout is %d ms and the call timeout is %d ms.", ChangesFollower.class.getSimpleName(), ChangesOptionsHelper.MIN_CLIENT_TIMEOUT, readTimeout, callTimeout));
        }
    }

    public Stream<ChangesResultItem> start() throws IllegalStateException, ServiceResponseException {
        return this.run(Mode.LISTEN);
    }

    public Stream<ChangesResultItem> startOneOff() throws IllegalStateException, ServiceResponseException {
        return this.run(Mode.FINITE);
    }

    public synchronized void stop() throws IllegalStateException {
        ChangesResultSpliterator spliterator = this.changesResultSpliterator.get();
        if (spliterator == null) {
            throw new IllegalStateException("Cannot stop a feed that is not running.");
        }
        spliterator.stop();
    }

    private synchronized Stream<ChangesResultItem> run(Mode mode) throws IllegalStateException, ServiceResponseException {
        AtomicLong batchSize;
        ChangesResultSpliterator spliterator = this.changesResultSpliterator.get();
        if (spliterator == null) {
            batchSize = new AtomicLong(BATCH_SIZE);
            if (Optional.ofNullable(this.options.includeDocs()).orElse(false).booleanValue()) {
                DatabaseInformation info = (DatabaseInformation)((Object)this.client.getDatabaseInformation(new GetDatabaseInformationOptions.Builder(this.options.db()).build()).execute().getResult());
                Long docs = Optional.ofNullable(info.getDocCount()).orElse(0L);
                Optional.ofNullable(info.getSizes()).ifPresent(sizes -> Optional.ofNullable(sizes.getExternal()).ifPresent(externalSize -> {
                    if (externalSize > 0L && docs > 0L) {
                        long calculatedBatchSize = 0x500000L / (externalSize / docs + 500L);
                        if (calculatedBatchSize >= 1L) {
                            batchSize.set(calculatedBatchSize);
                        } else {
                            batchSize.set(1L);
                        }
                    }
                }));
            }
            if (this.limit != null && this.limit < batchSize.get()) {
                batchSize.set(this.limit);
            }
        } else {
            throw new IllegalStateException("Cannot start a feed that has already started.");
        }
        this.changesResultSpliterator.set(new ChangesResultSpliterator(this.client, ChangesOptionsHelper.cloneOptionsWithModeAndNewLimit(this.options, mode, batchSize.get()), mode, this.errorTolerance));
        Stream<ChangesResultItem> changesStream = StreamSupport.stream(this.changesResultSpliterator.get(), false).flatMap(result -> result.getResults().stream());
        if (this.limit != null) {
            LOGGER.config(String.format("Applying changes limit %s", this.limit));
            changesStream = changesStream.limit(this.limit);
        }
        return changesStream;
    }

    static enum Mode {
        FINITE,
        LISTEN;

    }
}

