/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.CorsConfiguration;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PutCorsConfigurationOptions
extends GenericModel {
    protected Boolean allowCredentials;
    protected Boolean enableCors;
    protected List<String> origins;

    protected PutCorsConfigurationOptions(Builder builder) {
        this.allowCredentials = builder.allowCredentials;
        this.enableCors = builder.enableCors;
        this.origins = builder.origins;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public Boolean enableCors() {
        return this.enableCors;
    }

    public List<String> origins() {
        return this.origins;
    }

    public static class Builder {
        private Boolean allowCredentials;
        private Boolean enableCors;
        private List<String> origins;

        private Builder(PutCorsConfigurationOptions putCorsConfigurationOptions) {
            this.allowCredentials = putCorsConfigurationOptions.allowCredentials;
            this.enableCors = putCorsConfigurationOptions.enableCors;
            this.origins = putCorsConfigurationOptions.origins;
        }

        public Builder() {
        }

        public PutCorsConfigurationOptions build() {
            return new PutCorsConfigurationOptions(this);
        }

        public Builder addOrigins(String origins) {
            Validator.notNull((Object)origins, (String)"origins cannot be null");
            if (this.origins == null) {
                this.origins = new ArrayList<String>();
            }
            this.origins.add(origins);
            return this;
        }

        public Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public Builder enableCors(Boolean enableCors) {
            this.enableCors = enableCors;
            return this;
        }

        public Builder origins(List<String> origins) {
            this.origins = origins;
            return this;
        }

        public Builder corsConfiguration(CorsConfiguration corsConfiguration) {
            this.allowCredentials = corsConfiguration.allowCredentials();
            this.enableCors = corsConfiguration.enableCors();
            this.origins = corsConfiguration.origins();
            return this;
        }
    }
}

