/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.SecurityObject;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.List;
import java.util.Map;

public class PutCloudantSecurityConfigurationOptions
extends GenericModel {
    protected String db;
    protected SecurityObject admins;
    protected SecurityObject members;
    protected Map<String, List<String>> cloudant;
    protected Boolean couchdbAuthOnly;

    protected PutCloudantSecurityConfigurationOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.admins = builder.admins;
        this.members = builder.members;
        this.cloudant = builder.cloudant;
        this.couchdbAuthOnly = builder.couchdbAuthOnly;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public SecurityObject admins() {
        return this.admins;
    }

    public SecurityObject members() {
        return this.members;
    }

    public Map<String, List<String>> cloudant() {
        return this.cloudant;
    }

    public Boolean couchdbAuthOnly() {
        return this.couchdbAuthOnly;
    }

    public static class Builder {
        private String db;
        private SecurityObject admins;
        private SecurityObject members;
        private Map<String, List<String>> cloudant;
        private Boolean couchdbAuthOnly;

        private Builder(PutCloudantSecurityConfigurationOptions putCloudantSecurityConfigurationOptions) {
            this.db = putCloudantSecurityConfigurationOptions.db;
            this.admins = putCloudantSecurityConfigurationOptions.admins;
            this.members = putCloudantSecurityConfigurationOptions.members;
            this.cloudant = putCloudantSecurityConfigurationOptions.cloudant;
            this.couchdbAuthOnly = putCloudantSecurityConfigurationOptions.couchdbAuthOnly;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PutCloudantSecurityConfigurationOptions build() {
            return new PutCloudantSecurityConfigurationOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder admins(SecurityObject admins) {
            this.admins = admins;
            return this;
        }

        public Builder members(SecurityObject members) {
            this.members = members;
            return this;
        }

        public Builder cloudant(Map<String, List<String>> cloudant) {
            this.cloudant = cloudant;
            return this;
        }

        public Builder couchdbAuthOnly(Boolean couchdbAuthOnly) {
            this.couchdbAuthOnly = couchdbAuthOnly;
            return this;
        }
    }
}

