/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.AllDocsQuery;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostAllDocsQueriesOptions
extends GenericModel {
    protected String db;
    protected List<AllDocsQuery> queries;

    protected PostAllDocsQueriesOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.queries = builder.queries;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public List<AllDocsQuery> queries() {
        return this.queries;
    }

    public static class Builder {
        private String db;
        private List<AllDocsQuery> queries;

        private Builder(PostAllDocsQueriesOptions postAllDocsQueriesOptions) {
            this.db = postAllDocsQueriesOptions.db;
            this.queries = postAllDocsQueriesOptions.queries;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostAllDocsQueriesOptions build() {
            return new PostAllDocsQueriesOptions(this);
        }

        public Builder addQueries(AllDocsQuery queries) {
            Validator.notNull((Object)((Object)queries), (String)"queries cannot be null");
            if (this.queries == null) {
                this.queries = new ArrayList<AllDocsQuery>();
            }
            this.queries.add(queries);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder queries(List<AllDocsQuery> queries) {
            this.queries = queries;
            return this;
        }
    }
}

