/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.List;
import java.util.Map;

public class PutCloudantSecurityOptions
extends GenericModel {
    protected String db;
    protected Map<String, List<String>> cloudant;

    protected PutCloudantSecurityOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.cloudant = builder.cloudant;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public Map<String, List<String>> cloudant() {
        return this.cloudant;
    }

    public static class Builder {
        private String db;
        private Map<String, List<String>> cloudant;

        private Builder(PutCloudantSecurityOptions putCloudantSecurityOptions) {
            this.db = putCloudantSecurityOptions.db;
            this.cloudant = putCloudantSecurityOptions.cloudant;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PutCloudantSecurityOptions build() {
            return new PutCloudantSecurityOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder cloudant(Map<String, List<String>> cloudant) {
            this.cloudant = cloudant;
            return this;
        }
    }
}

