/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.internal;

import com.ibm.cloud.cloudant.security.CouchDbSessionAuthenticator;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.service.BaseService;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.Consumer;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class CloudantBaseService
extends BaseService {
    private int serviceUrlPathSegmentSize = 0;
    static final Map<String, EnumSet<ValidationRule>> rulesByOperation = new TreeMap<String, EnumSet<ValidationRule>>();

    public CloudantBaseService(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
    }

    protected OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = super.configureHttpClient().newBuilder();
        this.customizeAuthenticator(a -> builder.cookieJar((CookieJar)a.getCookieJar()));
        return builder.build();
    }

    public void setServiceUrl(String serviceUrl) {
        super.setServiceUrl(serviceUrl);
        serviceUrl = this.getServiceUrl();
        HttpUrl sUrl = HttpUrl.parse((String)serviceUrl);
        if (sUrl != null) {
            List serviceUrlSegements = sUrl.encodedPathSegments();
            this.serviceUrlPathSegmentSize = serviceUrlSegements.size() == 1 && ((String)serviceUrlSegements.get(0)).isEmpty() ? 0 : serviceUrlSegements.size();
        }
        this.customizeAuthenticator(a -> {
            a.setSessionUrl(this.getServiceUrl());
            a.invalidateToken();
        });
    }

    public void configureClient(HttpConfigOptions options) {
        super.configureClient(options);
        this.customizeAuthenticator(a -> a.setHttpConfigOptions(options));
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        super.setDefaultHeaders(headers);
        this.customizeAuthenticator(a -> a.setHeaders(headers));
    }

    private void customizeAuthenticator(Consumer<CouchDbSessionAuthenticator> consumer) {
        Authenticator authenticator = this.getAuthenticator();
        if (authenticator instanceof CouchDbSessionAuthenticator) {
            consumer.accept((CouchDbSessionAuthenticator)authenticator);
        }
    }

    protected <T> ServiceCall<T> createServiceCall(Request request, ResponseConverter<T> converter) {
        String operationId = null;
        String header = request.header("X-IBMCloud-SDK-Analytics");
        if (header != null) {
            StringTokenizer tokenizer = new StringTokenizer(request.header("X-IBMCloud-SDK-Analytics"), "=;");
            while (tokenizer.hasMoreTokens()) {
                if (!"operation_id".equals(tokenizer.nextToken())) continue;
                operationId = tokenizer.nextToken();
                break;
            }
        }
        if (operationId != null) {
            List requestUrlPathSegments = request.url().pathSegments();
            if (requestUrlPathSegments.size() == 1 && requestUrlPathSegments.contains("")) {
                requestUrlPathSegments = Collections.emptyList();
            }
            for (ValidationRule rule : rulesByOperation.getOrDefault(operationId, ValidationRule.NONE)) {
                String segmentToValidate;
                int pathSegmentIndex = this.serviceUrlPathSegmentSize + rule.pathSegmentIndex;
                if (requestUrlPathSegments.size() <= pathSegmentIndex || !(segmentToValidate = (String)requestUrlPathSegments.get(pathSegmentIndex)).startsWith("_")) continue;
                throw new IllegalArgumentException(String.format("%s %s starts with the invalid _ character.", rule.errorParameterName, segmentToValidate));
            }
        }
        return super.createServiceCall(request, converter);
    }

    static {
        for (ValidationRule rule : ValidationRule.values()) {
            for (String operationId : rule.operationIds) {
                EnumSet<ValidationRule> existing = rulesByOperation.putIfAbsent(operationId, EnumSet.of(rule));
                if (existing == null) continue;
                existing.add(rule);
            }
        }
    }

    private static enum ValidationRule {
        DOC_ID(1, "Document ID", Arrays.asList("deleteDocument", "getDocument", "headDocument", "putDocument", "deleteAttachment", "getAttachment", "headAttachment", "putAttachment")),
        ATT_NAME(2, "Attachment name", Arrays.asList("deleteAttachment", "getAttachment", "headAttachment", "putAttachment"));

        private static final EnumSet<ValidationRule> NONE;
        private final int pathSegmentIndex;
        private final String errorParameterName;
        private final List<String> operationIds;

        private ValidationRule(int pathSegmentIndex, String errorParameterName, List<String> operationIds) {
            this.pathSegmentIndex = pathSegmentIndex;
            this.errorParameterName = errorParameterName;
            this.operationIds = operationIds;
        }

        static {
            NONE = EnumSet.noneOf(ValidationRule.class);
        }
    }
}

