/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.xjcl.impl;

import com.ibm.batch.container.xjcl.ControlElement;
import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.Transition;
import com.ibm.batch.container.xjcl.impl.GlobPatternMatcherImpl;
import com.ibm.batch.container.xjcl.impl.TransitionImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.Next;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;
import jsr352.batch.jsl.Stop;

public class FlowNavigatorImpl
implements Navigator<Flow> {
    private static final Logger logger = Logger.getLogger(FlowNavigatorImpl.class.getName());
    private Flow flow = null;

    public FlowNavigatorImpl(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Transition getNextTransition(ExecutionElement currentElem, String currentExitStatus) {
        String method = "getNextTransition";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getNextTransition ,currentExitStatus=" + currentExitStatus);
        }
        String nextAttrId = null;
        ExecutionElement nextExecutionElement = null;
        TransitionImpl returnTransition = new TransitionImpl();
        if (currentElem instanceof Step) {
            nextAttrId = ((Step)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementByID(nextAttrId);
        } else if (currentElem instanceof Split) {
            nextAttrId = ((Split)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementByID(nextAttrId);
        } else if (currentElem instanceof Flow) {
            nextAttrId = ((Flow)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementByID(nextAttrId);
        } else if (currentElem instanceof Decision) {
            // empty if block
        }
        List<ControlElement> controlElements = currentElem.getControlElements();
        if (nextExecutionElement == null && controlElements.isEmpty()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getNextTransition return null, there is no next step");
            }
            return returnTransition;
        }
        if (nextExecutionElement != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getNextTransition return execution element:" + nextExecutionElement);
            }
            returnTransition.setNextExecutionElement(nextExecutionElement);
            return returnTransition;
        }
        if (controlElements.size() > 0) {
            for (ControlElement elem : controlElements) {
                boolean isMatched;
                String exitStatusToMatch;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("getNextTransition Trying to match next control element: " + elem);
                }
                if (elem instanceof Stop) {
                    exitStatusToMatch = ((Stop)elem).getOn();
                    isMatched = FlowNavigatorImpl.matchSpecifiedExitStatus(currentExitStatus, exitStatusToMatch);
                    if (!isMatched) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("getNextTransition , Stop element matches to " + exitStatusToMatch);
                    }
                    returnTransition.setControlElement(elem);
                    return returnTransition;
                }
                if (elem instanceof End) {
                    exitStatusToMatch = ((End)elem).getOn();
                    isMatched = FlowNavigatorImpl.matchSpecifiedExitStatus(currentExitStatus, exitStatusToMatch);
                    if (!isMatched) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("getNextTransition , End element matches to " + exitStatusToMatch);
                    }
                    returnTransition.setControlElement(elem);
                    return returnTransition;
                }
                if (elem instanceof Fail) {
                    exitStatusToMatch = ((Fail)elem).getOn();
                    isMatched = FlowNavigatorImpl.matchSpecifiedExitStatus(currentExitStatus, exitStatusToMatch);
                    if (!isMatched) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("getNextTransition , Fail element matches to " + exitStatusToMatch);
                    }
                    returnTransition.setControlElement(elem);
                    return returnTransition;
                }
                if (elem instanceof Next) {
                    exitStatusToMatch = ((Next)elem).getOn();
                    isMatched = FlowNavigatorImpl.matchSpecifiedExitStatus(currentExitStatus, exitStatusToMatch);
                    if (!isMatched) continue;
                    nextExecutionElement = this.getExecutionElementByID(((Next)elem).getTo());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("getNextTransition , match to " + exitStatusToMatch + ". Continue to step " + nextExecutionElement.getId());
                    }
                    returnTransition.setNextExecutionElement(nextExecutionElement);
                    return returnTransition;
                }
                throw new IllegalStateException("Shouldn't be possible to get here. Unknown control element,  " + elem.toString());
            }
        }
        return null;
    }

    @Override
    public Step getFirstExecutionElement(String restartOn) {
        String method = "getFirstExecutionElement";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getFirstExecutionElement , restartOn = " + restartOn);
        }
        ExecutionElement startElement = null;
        if (restartOn != null) {
            startElement = this.getExecutionElementByID(restartOn);
            if (startElement == null) {
                throw new IllegalStateException("Didn't find an execution element maching restart-on designated element: " + restartOn);
            }
        } else if (this.flow.getExecutionElements().size() > 0) {
            startElement = this.flow.getExecutionElements().get(0);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getFirstExecutionElement , Job appears to contain no execution elements.  Returning.");
            }
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getFirstExecutionElement , Found start element: " + startElement);
        }
        if (startElement instanceof Step) {
            return (Step)startElement;
        }
        throw new IllegalStateException("Didn't get this far yet implementing.\nOnly support <step> as first execution element.");
    }

    @Override
    public Flow getJSL() {
        return this.flow;
    }

    private ExecutionElement getExecutionElementByID(String id) {
        if (id != null) {
            for (ExecutionElement elem : this.flow.getExecutionElements()) {
                if (!elem.getId().equals(id)) continue;
                return elem;
            }
        }
        return null;
    }

    private static boolean matchSpecifiedExitStatus(String currentStepExitStatus, String exitStatusPattern) {
        GlobPatternMatcherImpl matcher;
        boolean match;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("matchSpecifiedExitStatus, matching current exitStatus  " + currentStepExitStatus + " against pattern: " + exitStatusPattern);
        }
        if (match = (matcher = new GlobPatternMatcherImpl()).matchWithoutBackslashEscape(currentStepExitStatus, exitStatusPattern)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("matchSpecifiedExitStatus, match=YES");
            }
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("matchSpecifiedExitStatus, match=NO");
        }
        return false;
    }

    @Override
    public String getId() {
        return this.flow.getId();
    }
}

