/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.exception.PersistenceException;
import com.ibm.batch.container.jobinstance.JobOperatorJobExecutionImpl;
import com.ibm.batch.container.jobinstance.StepExecutionImpl;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.impl.AbstractPersistenceManagerImpl;
import com.ibm.batch.container.status.JobStatus;
import com.ibm.batch.container.status.JobStatusKey;
import com.ibm.batch.container.status.StepStatus;
import com.ibm.batch.container.status.StepStatusKey;
import com.ibm.ws.batch.container.checkpoint.CheckpointData;
import com.ibm.ws.batch.container.checkpoint.CheckpointDataKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCPersistenceManagerImpl
extends AbstractPersistenceManagerImpl
implements IPersistenceManagerService {
    private static final String CLASSNAME = JDBCPersistenceManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final String JOBSTATUS_TABLE = "JOBSTATUS";
    private static final String STEPSTATUS_TABLE = "STEPSTATUS";
    private static final String CHECKPOINTDATA_TABLE = "CHECKPOINTDATA";
    private static final String JOBINSTANCEDATA_TABLE = "JOBINSTANCEDATA";
    private static final String EXECUTIONINSTANCEDATA_TABLE = "EXECUTIONINSTANCEDATA";
    private static final String STEPEXECUTIONINSTANCEDATA_TABLE = "STEPEXECUTIONINSTANCEDATA";
    private static final String CREATE_TAB_JOBSTATUS = "CREATE TABLE JOBSTATUS(id BIGINT,obj BLOB)";
    private static final String CREATE_TAB_STEPSTATUS = "CREATE TABLE STEPSTATUS(id VARCHAR(512),obj BLOB)";
    private static final String CREATE_TAB_CHECKPOINTDATA = "CREATE TABLE CHECKPOINTDATA(id VARCHAR(512),obj BLOB)";
    private static final String CREATE_TAB_JOBINSTANCEDATA = "CREATE TABLE JOBINSTANCEDATA(id VARCHAR(512), name VARCHAR(512))";
    private static final String CREATE_TAB_EXECUTIONINSTANCEDATA = "CREATE TABLE EXECUTIONINSTANCEDATA(id VARCHAR(512),createtime TIMESTAMP,starttime TIMESTAMP,endtime TIMESTAMP,updatetime TIMESTAMP,parameters BLOB,jobinstanceid VARCHAR(512),batchstatus VARCHAR(512),exitstatus VARCHAR(512))";
    private static final String CREATE_TAB_STEPEXECUTIONINSTANCEDATA = "CREATE TABLE STEPEXECUTIONINSTANCEDATA(id VARCHAR(512),jobexecid VARCHAR(512),stepexecid VARCHAR(512),batchstatus VARCHAR(512),exitstatus VARCHAR(512),stepname VARCHAR(512),readcount VARCHAR(512),writecount VARCHAR(512),commitcount VARCHAR(512),rollbackcount VARCHAR(512),readskipcount VARCHAR(512),processskipcount VARCHAR(512),filtercount VARCHAR(512),writeskipcount VARCHAR(512),startTime TIMESTAMP,endTime TIMESTAMP,persistentData BLOB)";
    private static final String INSERT_JOBSTATUS = "insert into jobstatus values(?, ?)";
    private static final String UPDATE_JOBSTATUS = "update jobstatus set obj = ? where id = ?";
    private static final String SELECT_JOBSTATUS = "select id, obj from jobstatus where id = ?";
    private static final String DELETE_JOBSTATUS = "delete from jobstatus where id = ?";
    private static final String INSERT_STEPSTATUS = "insert into stepstatus values(?, ?)";
    private static final String UPDATE_STEPSTATUS = "update stepstatus set obj = ? where id = ?";
    private static final String SELECT_STEPSTATUS = "select id, obj from stepstatus where id = ?";
    private static final String DELETE_STEPSTATUS = "delete from stepstatus where id = ?";
    private static final String INSERT_CHECKPOINTDATA = "insert into checkpointdata values(?, ?)";
    private static final String UPDATE_CHECKPOINTDATA = "update checkpointdata set obj = ? where id = ?";
    private static final String SELECT_CHECKPOINTDATA = "select id, obj from checkpointdata where id = ?";
    private static final String DELETE_CHECKPOINTDATA = "delete from checkpointdata where id = ?";
    private static final String INSERT_JOBINSTANCEDATA = "insert into jobinstancedata values(?, ?)";
    private static final String INSERT_EXECUTIONDATA = "insert into executionInstanceData values(?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_JOBINSTANCEDATA_COUNT = "select count(id) as jobinstancecount from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_IDS = "select id from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_NAMES = "select name from jobinstancedata";
    public static final String START_TIME = "starttime";
    public static final String CREATE_TIME = "createtime";
    public static final String END_TIME = "endtime";
    public static final String UPDATE_TIME = "updatetime";
    public static final String BATCH_STATUS = "batchstatus";
    public static final String EXIT_STATUS = "exitstatus";
    public static final String INSTANCE_ID = "instanceId";
    public static final String JOBEXEC_ID = "jobexecid";
    public static final String STEPEXEC_ID = "stepexecid";
    public static final String STEPCONTEXT = "stepcontext";
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String driver = "";
    protected String schema = "";
    protected String url = "";
    protected String userId = "";
    protected String pwd = "";

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        super.init(batchConfig);
        logger.entering(CLASSNAME, "init", batchConfig);
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        if (!batchConfig.isJ2seMode()) {
            this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
            logger.log(Level.FINE, "JNDI name is {0}", this.jndiName);
            if (this.jndiName == null || this.jndiName.equals("")) {
                throw new BatchContainerServiceException("JNDI name is not defined.");
            }
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
                throw new BatchContainerServiceException(e);
            }
        } else {
            this.driver = batchConfig.getDatabaseConfigurationBean().getJdbcDriver();
            this.url = batchConfig.getDatabaseConfigurationBean().getJdbcUrl();
            this.userId = batchConfig.getDatabaseConfigurationBean().getDbUser();
            this.pwd = batchConfig.getDatabaseConfigurationBean().getDbPassword();
            logger.log(Level.FINE, "driver: {0}, url: {1}", new Object[]{this.driver, this.url});
        }
        try {
            if (!this.isSchemaValid()) {
                this.createSchema();
            }
            this.checkAllTables();
        }
        catch (SQLException e) {
            logger.severe("failed to create missing tables");
            throw new BatchContainerServiceException(e);
        }
        logger.exiting(CLASSNAME, "init");
    }

    private boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isSchemaValid");
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSchemas();
        while (rs.next()) {
            if (!this.schema.equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
            this.cleanupConnection(conn, rs, null);
            logger.exiting(CLASSNAME, "isSchemaValid", true);
            return true;
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isSchemaValid", false);
        return false;
    }

    private void createSchema() throws SQLException {
        logger.entering(CLASSNAME, "createSchema");
        Connection conn = this.getConnectionToDefaultSchema();
        logger.log(Level.WARNING, this.schema + " schema does not exists. Trying to create it.");
        PreparedStatement ps = null;
        ps = conn.prepareStatement("CREATE SCHEMA " + this.schema);
        ps.execute();
        this.cleanupConnection(conn, null, ps);
        logger.exiting(CLASSNAME, "createSchema");
    }

    private void checkAllTables() throws SQLException {
        logger.entering(CLASSNAME, "checkAllTables");
        this.createIfNotExists(JOBSTATUS_TABLE, CREATE_TAB_JOBSTATUS);
        this.createIfNotExists(STEPSTATUS_TABLE, CREATE_TAB_STEPSTATUS);
        this.createIfNotExists(CHECKPOINTDATA_TABLE, CREATE_TAB_CHECKPOINTDATA);
        this.createIfNotExists(JOBINSTANCEDATA_TABLE, CREATE_TAB_JOBINSTANCEDATA);
        this.createIfNotExists(EXECUTIONINSTANCEDATA_TABLE, CREATE_TAB_EXECUTIONINSTANCEDATA);
        this.createIfNotExists(STEPEXECUTIONINSTANCEDATA_TABLE, CREATE_TAB_STEPEXECUTIONINSTANCEDATA);
        logger.exiting(CLASSNAME, "checkAllTables");
    }

    private void createIfNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createIfNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = this.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, this.schema, tableName, null);
        PreparedStatement ps = null;
        if (!rs.next()) {
            logger.log(Level.WARNING, tableName + " table does not exists. Trying to create it.");
            ps = conn.prepareStatement(createTableStatement);
            ps.executeUpdate();
        }
        this.cleanupConnection(conn, rs, ps);
        logger.exiting(CLASSNAME, "createIfNotExists");
    }

    @Override
    protected void _createJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_createJobStatus", new Object[]{key, value});
        this.executeInsert(key.getJobInstanceId(), value, INSERT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_createJobStatus");
    }

    @Override
    protected List<JobStatus> _getJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_getJobStatus", key);
        List<JobStatus> jobStatuses = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_getJobStatus", jobStatuses);
        return jobStatuses;
    }

    @Override
    protected void _updateJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_updateJobStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getJobInstanceId(), UPDATE_JOBSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateJobStatus");
    }

    @Override
    protected void _deleteJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_deleteJobStatus", key);
        this.executeDelete(key.getJobInstanceId(), DELETE_JOBSTATUS);
        logger.exiting(CLASSNAME, "_deleteJobStatus");
    }

    @Override
    protected void _createStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_createStepStatus", new Object[]{key, value});
        this.executeInsert(key.getKeyPrimitive(), value, INSERT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_createStepStatus");
    }

    @Override
    protected List<StepStatus> _getStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_getStepStatus", key);
        List<StepStatus> stepStatuses = this.executeQuery(key.getKeyPrimitive(), SELECT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_getStepStatus", stepStatuses);
        return stepStatuses;
    }

    @Override
    protected void _updateStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_updateStepStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getKeyPrimitive(), SELECT_STEPSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getKeyPrimitive(), UPDATE_STEPSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateStepStatus");
    }

    @Override
    protected void _deleteStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_deleteStepStatus", key);
        this.executeDelete(key.getKeyPrimitive(), DELETE_STEPSTATUS);
        logger.exiting(CLASSNAME, "_deleteStepStatus");
    }

    @Override
    protected void _createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "_createCheckpointData", new Object[]{key, value});
        this.executeInsert(key.getCommaSeparatedKey(), value, INSERT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_createCheckpointData");
    }

    @Override
    protected List<CheckpointData> _getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "_getCheckpointData", key);
        List<CheckpointData> checkpointData = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_getCheckpointData", checkpointData);
        return checkpointData;
    }

    @Override
    protected void _updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "_updateCheckpointData", new Object[]{key, value});
        List data = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getCommaSeparatedKey(), UPDATE_CHECKPOINTDATA);
        } else {
            this._createCheckpointData(key, value);
        }
        logger.exiting(CLASSNAME, "_updateCheckpointData");
    }

    @Override
    protected void _deleteCheckpointData(CheckpointDataKey key) {
        this.executeDelete(key.getJobInstanceId(), DELETE_CHECKPOINTDATA);
        logger.entering(CLASSNAME, "_deleteCheckpointData", key);
        this.executeDelete(key.getCommaSeparatedKey(), DELETE_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_deleteCheckpointData");
    }

    protected Connection getConnection() throws SQLException {
        logger.entering(CLASSNAME, "getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            logger.fine("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            logger.log(Level.FINE, "JSE mode, getting connection from {0}", this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            logger.fine("autocommit=" + connection.getAutoCommit());
        }
        this.setSchemaOnConnection(connection);
        logger.exiting(CLASSNAME, "getConnection", connection);
        return connection;
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        logger.entering(CLASSNAME, "getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            logger.fine("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                logger.log(Level.SEVERE, "ClassNotFoundException: Cannot load driver class: " + this.driver + "; Exception stack trace: " + sw);
                throw new PersistenceException(e);
            }
            logger.log(Level.FINE, "JSE mode, getting connection from {0}", this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            logger.fine("autocommit=" + connection.getAutoCommit());
        }
        logger.exiting(CLASSNAME, "getConnection", connection);
        return connection;
    }

    private void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.entering(CLASSNAME, "setSchemaOnConnection");
        PreparedStatement ps = null;
        ps = connection.prepareStatement("SET SCHEMA ?");
        ps.setString(1, this.schema);
        ps.executeUpdate();
        ps.close();
        logger.exiting(CLASSNAME, "setSchemaOnConnection");
    }

    private <T> void executeInsert(Object key, T value, String query) {
        logger.entering(CLASSNAME, "executeInsert", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setBytes(2, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeInsert");
    }

    private void executeJobInstanceDataInsert(long key, String jobName, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(jobName);
            byte[] b = baos.toByteArray();
            statement.setLong(1, key);
            statement.setString(2, jobName);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private void executeExecutionDataInsert(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String batchstatus, String exitstatus, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setLong(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            statement.setLong(7, instanceID);
            statement.setString(8, batchstatus);
            statement.setString(9, exitstatus);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private <T> void executeUpdate(T value, Object key, String query) {
        logger.entering(CLASSNAME, "executeUpdate", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeUpdate");
    }

    @Override
    public void jobExecutionTimestampUpdate(long key, String timestampToUpdate, Timestamp ts) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set " + timestampToUpdate + " = ? where id = ?");
            statement.setTimestamp(1, ts);
            statement.setObject(2, key);
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobExecutionStatusStringUpdate(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ? where id = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setLong(3, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    private void executeExecutionDataUpdate(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String status, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            statement.setString(7, status);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private void executeDelete(Object key, String query) {
        logger.entering(CLASSNAME, "executeDelete", new Object[]{key, query});
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setObject(1, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeDelete");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> List<T> executeQuery(Object key, String query) {
        ArrayList<Object> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            logger.entering(CLASSNAME, "executeQuery", new Object[]{key, query});
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<Object>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(query);
                statement.setObject(1, key);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    Object deSerializedObject = objectIn.readObject();
                    data.add(deSerializedObject);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "executeQuery");
        return data;
    }

    private List<Long> executeIDQuery(Object key, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> executeNameQuery(String query) {
        HashSet<String> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block10: {
            conn = null;
            statement = null;
            rs = null;
            data = new HashSet<String>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(query);
                rs = statement.executeQuery();
                while (rs.next()) {
                    String name = rs.getString("name");
                    data.add(name);
                }
                if (objectIn == null) break block10;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    private void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, rs, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }

    @Override
    public void jobOperatorCreateJobInstanceData(long key, String Value) {
        this.executeJobInstanceDataInsert(key, Value, INSERT_JOBINSTANCEDATA);
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object status = null;
        Object objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_COUNT);
            statement.setString(1, jobName);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public List<Long> jobOperatorgetJobInstanceIds(String jobName, int start, int count) {
        List<Long> data = this.executeIDQuery(jobName, SELECT_JOBINSTANCEDATA_IDS);
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data;
            }
        }
        return data;
    }

    @Override
    public Set<String> jobOperatorgetJobNames() {
        Set<String> data = this.executeNameQuery(SELECT_JOBINSTANCEDATA_NAMES);
        return data;
    }

    @Override
    public void jobOperatorCreateExecutionData(long key, Timestamp createTime, Timestamp starttime, Timestamp endtime, Timestamp updateTime, Properties parms, long instanceID, String batchstatus, String exitstatus) {
        this.executeExecutionDataInsert(key, createTime, starttime, endtime, updateTime, parms, instanceID, batchstatus, exitstatus, INSERT_EXECUTIONDATA);
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, String requestedTimestamp) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp timestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedTimestamp + " from executioninstancedata where id = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                timestamp = rs.getTimestamp(requestedTimestamp);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return timestamp;
    }

    @Override
    public String jobOperatorQueryJobExecutionStatus(long key, String requestedStatus) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        Object objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedStatus + " from executioninstancedata where id = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(requestedStatus);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where id = ?");
            statement.setLong(1, executionID);
            rs = statement.executeQuery();
            while (rs.next()) {
                jobinstanceID = rs.getLong("jobinstanceid");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobinstanceID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JobExecution> jobOperatorGetJobExecutionsByJobInstanceID(long jobInstanceID) {
        ArrayList<JobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<JobExecution>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select * from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, jobInstanceID);
                rs = statement.executeQuery();
                while (rs.next()) {
                    JobOperatorJobExecutionImpl jobExecutionImpl = new JobOperatorJobExecutionImpl(rs.getLong("id"), rs.getLong("jobinstanceid"), null);
                    jobExecutionImpl.setCreateTime(rs.getTimestamp(CREATE_TIME));
                    jobExecutionImpl.setStartTime(rs.getTimestamp(START_TIME));
                    jobExecutionImpl.setLastUpdateTime(rs.getTimestamp(UPDATE_TIME));
                    jobExecutionImpl.setEndTime(rs.getTimestamp(END_TIME));
                    jobExecutionImpl.setBatchStatus(rs.getString(BATCH_STATUS));
                    jobExecutionImpl.setExitStatus(rs.getString(EXIT_STATUS));
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    Properties props = (Properties)objectIn.readObject();
                    jobExecutionImpl.setJobProperties(props);
                    data.add(jobExecutionImpl);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getParameters(long instanceId) {
        Properties props;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            props = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select parameters from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, instanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    props = (Properties)objectIn.readObject();
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return props;
    }

    @Override
    public void stepExecutionCreateStepExecutionData(String stepExecutionKey, long jobExecutionID, StepContextImpl stepContext) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        long stepExecutionID = stepContext.getStepExecutionId();
        String batchStatus = stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getId();
        Object persistentData = stepContext.getPersistentUserData();
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        long readCnt = 0L;
        long writeCnt = 0L;
        long processSkipCnt = 0L;
        long commitCnt = 0L;
        long rollbackCnt = 0L;
        long readSkipCnt = 0L;
        long filterCnt = 0L;
        long writeSkipCnt = 0L;
        Timestamp startTimeTS = stepContext.getStartTimeTS();
        Timestamp endTimeTS = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getName().equals("readCount")) {
                readCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("writeCount")) {
                writeCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("processSkipCount")) {
                processSkipCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("commitCount")) {
                commitCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("rollbackCount")) {
                rollbackCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("readSkipCount")) {
                readSkipCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getName().equals("filterCount")) {
                filterCnt = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getName().equals("writeSkipCount")) continue;
            writeSkipCnt = metrics[i].getValue();
        }
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("insert into stepexecutionInstanceData values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, stepExecutionKey);
            statement.setLong(2, jobExecutionID);
            statement.setLong(3, stepExecutionID);
            statement.setString(4, batchStatus);
            statement.setString(5, exitStatus);
            statement.setString(6, stepName);
            statement.setLong(7, readCnt);
            statement.setLong(8, writeCnt);
            statement.setLong(9, commitCnt);
            statement.setLong(10, rollbackCnt);
            statement.setLong(11, readSkipCnt);
            statement.setLong(12, processSkipCnt);
            statement.setLong(13, filterCnt);
            statement.setLong(14, writeSkipCnt);
            statement.setTimestamp(15, startTimeTS);
            statement.setTimestamp(16, endTimeTS);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(persistentData);
            byte[] pdataBytes = baos.toByteArray();
            statement.setObject(17, pdataBytes);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, rs, statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution> getStepExecutionIDListQueryByJobID(long execid) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        Object persistentData = null;
        StepExecutionImpl stepEx = null;
        ObjectInputStream objectIn = null;
        ArrayList<StepExecution> data = new ArrayList<StepExecution>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select * from stepexecutioninstancedata where jobexecid = ?");
            statement.setLong(1, execid);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                jobexecid = rs.getLong(JOBEXEC_ID);
                stepexecid = rs.getLong(STEPEXEC_ID);
                stepname = rs.getString("stepname");
                batchstatus = rs.getString(BATCH_STATUS);
                exitstatus = rs.getString(EXIT_STATUS);
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new ObjectInputStream(new ByteArrayInputStream(pDataBytes));
                }
                persistentData = objectIn.readObject();
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(JobOperator.BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setpersistentUserData(persistentData);
                data.add(stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepExecution getStepExecutionObjQueryByStepID(long stepExecutionId) {
        StepExecutionImpl stepEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            long jobexecid = 0L;
            long stepexecid = 0L;
            String stepname = null;
            String batchstatus = null;
            String exitstatus = null;
            Object ex = null;
            long readCount = 0L;
            long writeCount = 0L;
            long commitCount = 0L;
            long rollbackCount = 0L;
            long readSkipCount = 0L;
            long processSkipCount = 0L;
            long filterCount = 0L;
            long writeSkipCount = 0L;
            Timestamp startTS = null;
            Timestamp endTS = null;
            Object persistentDataObj = null;
            stepEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select * from stepexecutioninstancedata where stepexecid = ?");
                statement.setLong(1, stepExecutionId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    jobexecid = rs.getLong(JOBEXEC_ID);
                    stepexecid = rs.getLong(STEPEXEC_ID);
                    stepname = rs.getString("stepname");
                    batchstatus = rs.getString(BATCH_STATUS);
                    exitstatus = rs.getString(EXIT_STATUS);
                    readCount = rs.getLong("readcount");
                    writeCount = rs.getLong("writecount");
                    commitCount = rs.getLong("commitcount");
                    rollbackCount = rs.getLong("rollbackcount");
                    readSkipCount = rs.getLong("readskipcount");
                    processSkipCount = rs.getLong("processskipcount");
                    filterCount = rs.getLong("filtercount");
                    writeSkipCount = rs.getLong("writeSkipCount");
                    startTS = rs.getTimestamp("startTime");
                    endTS = rs.getTimestamp("endTime");
                    byte[] pDataBytes = rs.getBytes("persistentData");
                    if (pDataBytes != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    }
                    persistentDataObj = objectIn.readObject();
                    stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    stepEx.setBatchStatus(JobOperator.BatchStatus.valueOf((String)batchstatus));
                    stepEx.setExitStatus(exitstatus);
                    stepEx.setStepName(stepname);
                    stepEx.setReadCount(readCount);
                    stepEx.setWriteCount(writeCount);
                    stepEx.setCommitCount(commitCount);
                    stepEx.setRollbackCount(rollbackCount);
                    stepEx.setReadSkipCount(readSkipCount);
                    stepEx.setProcessSkipCount(processSkipCount);
                    stepEx.setFilterCount(filterCount);
                    stepEx.setWriteSkipCount(writeSkipCount);
                    stepEx.setStartTime(startTS);
                    stepEx.setEndTime(endTS);
                    stepEx.setpersistentUserData(persistentDataObj);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return stepEx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobOperatorUpdateBatchStatusWithUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ? where id = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setLong(3, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ? where id = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setLong(3, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        JobOperatorJobExecutionImpl jobEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            Timestamp createtime = null;
            Timestamp starttime = null;
            Timestamp endtime = null;
            Timestamp updatetime = null;
            Properties params = null;
            long instanceId = 0L;
            String batchStatus = null;
            String exitStatus = null;
            jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select createtime, starttime, endtime, updatetime, parameters, jobinstanceid, batchstatus, exitstatus  from executioninstancedata where id = ?");
                statement.setLong(1, jobExecutionId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    createtime = rs.getTimestamp(CREATE_TIME);
                    starttime = rs.getTimestamp(START_TIME);
                    endtime = rs.getTimestamp(END_TIME);
                    updatetime = rs.getTimestamp(UPDATE_TIME);
                    instanceId = rs.getLong("jobinstanceid");
                    batchStatus = rs.getString(BATCH_STATUS);
                    exitStatus = rs.getString(EXIT_STATUS);
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    params = (Properties)objectIn.readObject();
                    jobEx = new JobOperatorJobExecutionImpl(jobExecutionId, instanceId, null);
                    jobEx.setCreateTime(createtime);
                    jobEx.setStartTime(starttime);
                    jobEx.setEndTime(endtime);
                    jobEx.setJobProperties(params);
                    jobEx.setLastUpdateTime(updatetime);
                    jobEx.setBatchStatus(batchStatus);
                    jobEx.setExitStatus(exitStatus);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return jobEx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        ArrayList<JobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            Timestamp createtime = null;
            Timestamp starttime = null;
            Timestamp endtime = null;
            Timestamp updatetime = null;
            Properties params = null;
            long jobExecutionId = 0L;
            long instanceId = 0L;
            String batchStatus = null;
            String exitStatus = null;
            data = new ArrayList<JobExecution>();
            JobOperatorJobExecutionImpl jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select id, createtime, starttime, endtime, updatetime, parameters, batchstatus, exitstatus  from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, jobInstanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    jobExecutionId = rs.getLong("id");
                    createtime = rs.getTimestamp(CREATE_TIME);
                    starttime = rs.getTimestamp(START_TIME);
                    endtime = rs.getTimestamp(END_TIME);
                    updatetime = rs.getTimestamp(UPDATE_TIME);
                    batchStatus = rs.getString(BATCH_STATUS);
                    exitStatus = rs.getString(EXIT_STATUS);
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    params = (Properties)objectIn.readObject();
                    jobEx = new JobOperatorJobExecutionImpl(jobExecutionId, instanceId, null);
                    jobEx.setCreateTime(createtime);
                    jobEx.setStartTime(starttime);
                    jobEx.setEndTime(endtime);
                    jobEx.setLastUpdateTime(updatetime);
                    jobEx.setBatchStatus(batchStatus);
                    jobEx.setExitStatus(exitStatus);
                    data.add(jobEx);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Long> jobOperatorGetRunningInstances(String jobName) {
        HashSet<Long> instanceIds2;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            long executionId = 0L;
            long instanceId = 0L;
            HashSet<Long> instanceIds1 = new HashSet<Long>();
            instanceIds2 = new HashSet<Long>();
            Object jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_IDS);
                statement.setString(1, jobName);
                rs = statement.executeQuery();
                while (rs.next()) {
                    instanceId = rs.getLong("id");
                    instanceIds1.add(instanceId);
                }
                statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobinstanceid = ? and batchstatus = ?");
                Iterator i$ = instanceIds1.iterator();
                while (i$.hasNext()) {
                    long id = (Long)i$.next();
                    statement.setLong(1, id);
                    statement.setString(2, JobOperator.BatchStatus.STARTED.name());
                    rs = statement.executeQuery();
                    while (rs.next()) {
                        instanceId = rs.getLong("jobinstanceid");
                    }
                    instanceIds2.add(instanceId);
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return instanceIds2;
    }
}

