/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.services.IBatchKernelService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.tck.bridge.IJobEndCallbackService;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.exception.JobExecutionIsRunningException;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.JobInstanceAlreadyCompleteException;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.operations.exception.NoSuchJobException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.operations.exception.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class JobOperatorImpl
implements JobOperator {
    private static final String sourceClass = JobOperatorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ServicesManager servicesManager = ServicesManager.getInstance();
    private IBatchKernelService batchKernel = (IBatchKernelService)this.servicesManager.getService(ServicesManager.ServiceType.BATCH_KERNEL_SERVICE);
    private IJobEndCallbackService callbackService = (IJobEndCallbackService)this.servicesManager.getService(ServicesManager.ServiceType.CALLBACK_SERVICE);
    private IPersistenceManagerService persistenceService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);

    public List<Long> getExecutions(long instanceId) throws NoSuchJobInstanceException {
        return this.batchKernel.getExecutionIds(instanceId);
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        int jobInstanceCount = 0;
        jobInstanceCount = this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
        if (jobInstanceCount > 0) {
            return jobInstanceCount;
        }
        throw new NoSuchJobException(null, "Job " + jobName + " not found");
    }

    public Set<String> getJobNames() {
        return this.persistenceService.jobOperatorgetJobNames();
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        return null;
    }

    public Long restart(long instanceId, Properties jobParameters) throws JobInstanceAlreadyCompleteException, NoSuchJobExecutionException, NoSuchJobException, JobRestartException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarting job with instanceID: " + instanceId);
        }
        JobExecution execution = this.batchKernel.restartJob(instanceId, jobParameters);
        long newExecutionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarted job with instanceID: " + instanceId + ", and new executionID: " + newExecutionId);
        }
        return newExecutionId;
    }

    public Long start(String jobXML, Properties jobParameters) throws JobStartException {
        Long retExecID = null;
        if (logger.isLoggable(Level.FINE)) {
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        JobExecution execution = this.batchKernel.startJob(jobXML, jobParameters);
        retExecID = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator start received executionId: " + retExecID);
        }
        return retExecID;
    }

    public void stop(long instanceId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        this.batchKernel.stopJob(instanceId);
    }

    public JobExecution getJobExecution(long executionId) {
        return this.batchKernel.getJobExecution(executionId);
    }

    public StepExecution getStepExecution(long jobExecutionId, long stepExecutionId) {
        return this.batchKernel.getStepExecution(jobExecutionId, stepExecutionId);
    }

    public List<StepExecution> getJobSteps(long jobExecutionId) {
        return this.batchKernel.getJobSteps(jobExecutionId);
    }

    public List<JobExecution> getJobExecutions(long instanceId) {
        return null;
    }

    public List<Long> getJobInstanceIds(String jobName, int start, int count) throws NoSuchJobException {
        return this.persistenceService.jobOperatorgetJobInstanceIds(jobName, start, count);
    }

    public Set<Long> getRunningInstanceIds(String jobName) throws NoSuchJobException {
        return null;
    }

    public void abandon(long instanceId) throws NoSuchJobExecutionException, JobExecutionIsRunningException {
    }

    public JobInstance getJobInstance(long instanceId) {
        return null;
    }
}

