/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.exception.IllegalBatchPropertyException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.runtime.context.FlowContext;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.SplitContext;
import javax.batch.runtime.context.StepContext;
import jsr352.batch.jsl.Property;

public abstract class AbstractProxy {
    private static final String sourceClass = AbstractProxy.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected Object delegate;
    private JobContext<?> jobContext;
    private StepContext<?, ?> stepContext;
    private SplitContext splitContext;
    private FlowContext flowContext;
    private ArrayList<Field> jobContextFields;
    private ArrayList<Field> stepContextFields;
    private ArrayList<Field> splitContextFields;
    private ArrayList<Field> flowContextFields;
    protected HashMap<String, Field> propertyMap;

    AbstractProxy(Object delegate, List<Property> props) {
        this.delegate = delegate;
        this.findPropertyFields(delegate);
        this.findBatchContextFields(delegate);
        if (props != null) {
            this.injectProperties(props);
        }
    }

    private void setProperty(String name, String value) {
        Field propertyField = this.propertyMap.get(name);
        if (propertyField != null) {
            try {
                propertyField.set(this.delegate, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalBatchPropertyException("The given property value is not an instance of the declared field.", e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException("Field is not accesible.", e);
            }
        } else {
            throw new IllegalBatchPropertyException("An annotated property by the name, " + name + ", does not exist in this scope.");
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setJobContext(JobContext<?> jobContext) {
        this.jobContext = jobContext;
        if (this.jobContextFields != null) {
            for (Field field : this.jobContextFields) {
                try {
                    field.set(this.delegate, jobContext);
                }
                catch (IllegalArgumentException e) {
                    throw new BatchContainerRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new BatchContainerRuntimeException(e);
                }
            }
        }
    }

    public JobContext<?> getJobContext() {
        return this.jobContext;
    }

    public void setStepContext(StepContext<?, ?> stepContext) {
        this.stepContext = stepContext;
        if (this.stepContextFields != null) {
            for (Field field : this.stepContextFields) {
                try {
                    field.set(this.delegate, stepContext);
                }
                catch (IllegalArgumentException e) {
                    throw new BatchContainerRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new BatchContainerRuntimeException(e);
                }
            }
        }
    }

    public void setFlowContext(FlowContext flowContext) {
        this.flowContext = flowContext;
        if (this.flowContextFields != null) {
            for (Field field : this.stepContextFields) {
                try {
                    field.set(this.delegate, flowContext);
                }
                catch (IllegalArgumentException e) {
                    throw new BatchContainerRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new BatchContainerRuntimeException(e);
                }
            }
        }
    }

    public StepContext<?, ?> getStepContext() {
        return this.stepContext;
    }

    public SplitContext getSplitContext() {
        return this.splitContext;
    }

    public FlowContext getFlowContext() {
        return this.flowContext;
    }

    public void setSplitContext(SplitContext splitContext) {
        this.splitContext = splitContext;
    }

    void injectProperties(List<Property> props) {
        if (props == null || this.propertyMap == null) {
            return;
        }
        for (Map.Entry<String, Field> batchProperty : this.propertyMap.entrySet()) {
            String propValue = this.getPropertyValue(props, batchProperty.getKey());
            if (propValue == null) continue;
            try {
                batchProperty.getValue().set(this.delegate, propValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalBatchPropertyException("The given property value is not an instance of the declared field.", e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    private String getPropertyValue(List<Property> props, String name) {
        for (Property prop : props) {
            if (!name.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    private void findBatchContextFields(Object delegate) {
        for (final Field field : delegate.getClass().getDeclaredFields()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            BatchContext batchContext = field.getAnnotation(BatchContext.class);
            if (batchContext == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Found @JobContext on (Object, field)", new Object[]{delegate, field.getName()});
            }
            Class<?> clazz = field.getType();
            if (JobContext.class.isAssignableFrom(field.getType())) {
                if (this.jobContextFields == null) {
                    this.jobContextFields = new ArrayList();
                }
                this.jobContextFields.add(field);
                continue;
            }
            if (StepContext.class.isAssignableFrom(field.getType())) {
                if (this.stepContextFields == null) {
                    this.stepContextFields = new ArrayList();
                }
                this.stepContextFields.add(field);
                continue;
            }
            if (SplitContext.class.isAssignableFrom(field.getType())) {
                if (this.splitContextFields == null) {
                    this.splitContextFields = new ArrayList();
                }
                this.splitContextFields.add(field);
                continue;
            }
            if (!FlowContext.class.isAssignableFrom(field.getType())) continue;
            if (this.flowContextFields == null) {
                this.flowContextFields = new ArrayList();
            }
            this.flowContextFields.add(field);
        }
    }

    public void findPropertyFields(Object delegate) {
        for (final Field field : delegate.getClass().getDeclaredFields()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            BatchProperty batchPropertyAnnotation = field.getAnnotation(BatchProperty.class);
            if (batchPropertyAnnotation == null) continue;
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap();
            }
            String batchPropName = null;
            batchPropName = batchPropertyAnnotation.name().equals("") ? field.getName() : batchPropertyAnnotation.name();
            if (this.propertyMap.containsKey(batchPropName)) {
                throw new IllegalBatchPropertyException("There is already a batch property with this name: " + batchPropName);
            }
            this.propertyMap.put(batchPropName, field);
        }
    }
}

