/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.batch.container.checkpoint;

import com.ibm.ws.batch.container.checkpoint.CheckpointAlgorithm;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private static final String className = ItemCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(ItemCheckpointAlgorithm.class.getPackage().getName());
    CheckpointAlgorithm ichkp = null;
    boolean inCheckpoint = false;
    private static final int defaultRecordValue = 10;
    private static final int defaultTimeoutValue = 60;
    int threshold = 10;
    long timeStarted = 0L;
    long requests = 0L;
    int timeout = 60;

    public void beginCheckpoint() throws Exception {
        this.inCheckpoint = true;
        this.timeStarted = new Date().getTime();
    }

    public void endCheckpoint() throws Exception {
        this.inCheckpoint = false;
    }

    public int getCheckpointTimeOut(int timeOut) throws Exception {
        return this.timeout;
    }

    @Override
    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready;
        String method = "ShouldCheckpointBeExecuted";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        ++this.requests;
        boolean bl = ready = this.requests >= (long)this.threshold;
        if (ready) {
            long millis = new Date().getTime() - this.timeStarted;
            if (millis > 0L) {
                String rate = Integer.valueOf(Long.valueOf(this.requests * 1000L / millis).intValue()).toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" - true [requests/second " + rate + "]");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(" - true [requests " + this.requests + "]");
            }
        }
        if (ready) {
            this.requests = 0L;
        }
        return ready;
    }

    @Override
    public void setThreshold(int INthreshHold) {
        this.threshold = INthreshHold;
    }

    @Override
    public void setThresholds(int itemthreshold, int timethreshold) {
    }
}

