/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.ParallelTaskResult;
import com.ibm.batch.container.services.impl.JSEResultAdapter;
import com.ibm.batch.container.util.BatchWorkUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractThreadPoolServiceImpl
implements IBatchThreadPoolService {
    private static final String sourceClass = AbstractThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected ExecutorService executorService;

    public AbstractThreadPoolServiceImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Instantiating instance of thread pool impl: " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public abstract void init(IBatchConfig var1) throws BatchContainerServiceException;

    @Override
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this.executorService.shutdownNow();
        this.executorService = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void executeTask(BatchWorkUnit work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this.executorService.execute(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public ParallelTaskResult executeParallelTask(BatchWorkUnit work, Object config) {
        String method = "executeParallelTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> result = this.executorService.submit(work);
        JSEResultAdapter taskResult = new JSEResultAdapter(result);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return taskResult;
    }
}

