/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterJob;
import javax.batch.annotation.BeforeJob;
import jsr352.batch.jsl.Property;

public class JobListenerProxy
extends AbstractProxy {
    private Method afterJobMethod = null;
    private Method beforeJobMethod = null;

    JobListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            AfterJob afterJob;
            BeforeJob beforeJob = method.getAnnotation(BeforeJob.class);
            if (beforeJob != null) {
                this.beforeJobMethod = method;
            }
            if ((afterJob = method.getAnnotation(AfterJob.class)) == null) continue;
            this.afterJobMethod = method;
        }
    }

    public void beforeJob() {
        if (this.beforeJobMethod != null) {
            try {
                this.beforeJobMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterJob() {
        if (this.afterJobMethod != null) {
            try {
                this.afterJobMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

