/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.io.Externalizable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.Close;
import javax.batch.annotation.Open;
import javax.batch.annotation.WriteItems;
import jsr352.batch.jsl.Property;

public class ItemWriterProxy
extends AbstractProxy {
    private Method openMethod = null;
    private Method closeMethod = null;
    private Method writeItemsMethod = null;
    private Method checkpointInfoMethod = null;

    ItemWriterProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            CheckpointInfo checkpointInfoWriter;
            WriteItems writeItemsWriter;
            Close closeWriter;
            Open openWriter = method.getAnnotation(Open.class);
            if (openWriter != null) {
                this.openMethod = method;
            }
            if ((closeWriter = method.getAnnotation(Close.class)) != null) {
                this.closeMethod = method;
            }
            if ((writeItemsWriter = method.getAnnotation(WriteItems.class)) != null) {
                this.writeItemsMethod = method;
            }
            if ((checkpointInfoWriter = method.getAnnotation(CheckpointInfo.class)) == null) continue;
            this.checkpointInfoMethod = method;
        }
    }

    public void openWriter(Object checkpoint) {
        if (this.openMethod != null) {
            try {
                this.openMethod.invoke(this.delegate, checkpoint);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void closeWriter() {
        if (this.closeMethod != null) {
            try {
                this.closeMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void writeItems(List<Object> items) throws Throwable {
        if (this.writeItemsMethod != null) {
            try {
                this.writeItemsMethod.invoke(this.delegate, items);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public Externalizable checkpointInfo() {
        Externalizable chkpoint = null;
        if (this.checkpointInfoMethod != null) {
            try {
                chkpoint = (Externalizable)this.checkpointInfoMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        return chkpoint;
    }

    public Method getOpenMethod() {
        return this.openMethod;
    }

    public Method getCloseMethod() {
        return this.closeMethod;
    }

    public Method getWriteItemsMethod() {
        return this.writeItemsMethod;
    }

    public Method getCheckpointInfoMethod() {
        return this.checkpointInfoMethod;
    }
}

