/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.exception.PersistenceException;
import com.ibm.batch.container.jobinstance.StepExecutionImpl;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.impl.AbstractPersistenceManagerImpl;
import com.ibm.batch.container.status.JobStatus;
import com.ibm.batch.container.status.JobStatusKey;
import com.ibm.batch.container.status.StepStatus;
import com.ibm.batch.container.status.StepStatusKey;
import com.ibm.ws.batch.container.checkpoint.CheckpointData;
import com.ibm.ws.batch.container.checkpoint.CheckpointDataKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCPersistenceManagerImpl
extends AbstractPersistenceManagerImpl
implements IPersistenceManagerService {
    private static final String CLASSNAME = JDBCPersistenceManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final String INSERT_JOBSTATUS = "insert into jobstatus values(?, ?)";
    private static final String UPDATE_JOBSTATUS = "update jobstatus set obj = ? where id = ?";
    private static final String SELECT_JOBSTATUS = "select id, obj from jobstatus where id = ?";
    private static final String DELETE_JOBSTATUS = "delete from jobstatus where id = ?";
    private static final String INSERT_STEPSTATUS = "insert into stepstatus values(?, ?)";
    private static final String UPDATE_STEPSTATUS = "update stepstatus set obj = ? where id = ?";
    private static final String SELECT_STEPSTATUS = "select id, obj from stepstatus where id = ?";
    private static final String DELETE_STEPSTATUS = "delete from stepstatus where id = ?";
    private static final String INSERT_CHECKPOINTDATA = "insert into checkpointdata values(?, ?)";
    private static final String UPDATE_CHECKPOINTDATA = "update checkpointdata set obj = ? where id = ?";
    private static final String SELECT_CHECKPOINTDATA = "select id, obj from checkpointdata where id = ?";
    private static final String DELETE_CHECKPOINTDATA = "delete from checkpointdata where id = ?";
    private static final String INSERT_JOBINSTANCEDATA = "insert into jobinstancedata values(?, ?)";
    private static final String INSERT_EXECUTIONDATA = "insert into executionInstanceData values(?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_JOBINSTANCEDATA_COUNT = "select count(name) from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_IDS = "select id from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_NAMES = "select name from jobinstancedata";
    public static final String START_TIME = "starttime";
    public static final String CREATE_TIME = "createtime";
    public static final String END_TIME = "endtime";
    public static final String UPDATE_TIME = "updatetime";
    public static final String BATCH_STATUS = "batchstatus";
    public static final String EXIT_STATUS = "exitstatus";
    public static final String INSTANCE_ID = "instanceId";
    public static final String JOBEXEC_ID = "jobexecid";
    public static final String STEPEXEC_ID = "stepexecid";
    public static final String STEPCONTEXT = "stepcontext";
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String driver = "";
    protected String url = "";
    protected String userId = "";
    protected String pwd = "";

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        super.init(batchConfig);
        logger.entering(CLASSNAME, "init", batchConfig);
        if (!batchConfig.isJ2seMode()) {
            this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
            logger.log(Level.FINE, "JNDI name is {0}", this.jndiName);
            if (this.jndiName == null || this.jndiName.equals("")) {
                throw new BatchContainerServiceException("JNDI name is not defined.");
            }
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
                throw new BatchContainerServiceException(e);
            }
        } else {
            this.driver = batchConfig.getDatabaseConfigurationBean().getJdbcDriver();
            this.url = batchConfig.getDatabaseConfigurationBean().getJdbcUrl();
            this.userId = batchConfig.getDatabaseConfigurationBean().getDbUser();
            this.pwd = batchConfig.getDatabaseConfigurationBean().getDbPassword();
            logger.log(Level.FINE, "driver: {0}, url: {1}", new Object[]{this.driver, this.url});
        }
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    protected void _createJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_createJobStatus", new Object[]{key, value});
        this.executeInsert(key.getJobInstanceId(), value, INSERT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_createJobStatus");
    }

    @Override
    protected List<JobStatus> _getJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_getJobStatus", key);
        List<JobStatus> jobStatuses = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_getJobStatus", jobStatuses);
        return jobStatuses;
    }

    @Override
    protected void _updateJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_updateJobStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getJobInstanceId(), UPDATE_JOBSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateJobStatus");
    }

    @Override
    protected void _deleteJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_deleteJobStatus", key);
        this.executeDelete(key.getJobInstanceId(), DELETE_JOBSTATUS);
        logger.exiting(CLASSNAME, "_deleteJobStatus");
    }

    @Override
    protected void _createStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_createStepStatus", new Object[]{key, value});
        this.executeInsert(key.getKeyPrimitive(), value, INSERT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_createStepStatus");
    }

    @Override
    protected List<StepStatus> _getStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_getStepStatus", key);
        List<StepStatus> stepStatuses = this.executeQuery(key.getKeyPrimitive(), SELECT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_getStepStatus", stepStatuses);
        return stepStatuses;
    }

    @Override
    protected void _updateStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_updateStepStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getKeyPrimitive(), SELECT_STEPSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getKeyPrimitive(), UPDATE_STEPSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateStepStatus");
    }

    @Override
    protected void _deleteStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_deleteStepStatus", key);
        this.executeDelete(key.getKeyPrimitive(), DELETE_STEPSTATUS);
        logger.exiting(CLASSNAME, "_deleteStepStatus");
    }

    @Override
    protected void _createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        this.executeInsert(key.getJobInstanceId(), value, INSERT_CHECKPOINTDATA);
        logger.entering(CLASSNAME, "_createCheckpointData", new Object[]{key, value});
        this.executeInsert(key.getCommaSeparatedKey(), value, INSERT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_createCheckpointData");
    }

    @Override
    protected List<CheckpointData> _getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "_getCheckpointData", key);
        List<CheckpointData> checkpointData = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_getCheckpointData", checkpointData);
        return checkpointData;
    }

    @Override
    protected void _updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "_updateCheckpointData", new Object[]{key, value});
        List data = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getCommaSeparatedKey(), UPDATE_CHECKPOINTDATA);
        }
        logger.exiting(CLASSNAME, "_updateCheckpointData");
    }

    @Override
    protected void _deleteCheckpointData(CheckpointDataKey key) {
        this.executeDelete(key.getJobInstanceId(), DELETE_CHECKPOINTDATA);
        logger.entering(CLASSNAME, "_deleteCheckpointData", key);
        this.executeDelete(key.getCommaSeparatedKey(), DELETE_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_deleteCheckpointData");
    }

    protected Connection getConnection() throws SQLException {
        logger.entering(CLASSNAME, "getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            logger.fine("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            logger.log(Level.FINE, "JSE mode, getting connection from {0}", this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            connection.setAutoCommit(true);
            logger.fine("autocommit=" + connection.getAutoCommit());
        }
        logger.exiting(CLASSNAME, "getConnection", connection);
        return connection;
    }

    private <T> void executeInsert(Object key, T value, String query) {
        logger.entering(CLASSNAME, "executeInsert", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setBytes(2, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeInsert");
    }

    private void executeExecutionDataInsert(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String batchstatus, String exitstatus, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setLong(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            statement.setLong(7, instanceID);
            oout.reset();
            oout.writeObject(batchstatus);
            b = baos.toByteArray();
            statement.setBytes(8, b);
            oout.reset();
            oout.writeObject(exitstatus);
            b = baos.toByteArray();
            statement.setBytes(9, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private <T> void executeUpdate(T value, Object key, String query) {
        logger.entering(CLASSNAME, "executeUpdate", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeUpdate");
    }

    @Override
    public void jobExecutionTimestampUpdate(long key, String timestampToUpdate, Timestamp ts) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set " + timestampToUpdate + " = ? where id = ?");
            statement.setTimestamp(1, ts);
            statement.setObject(2, key);
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobExecutionStatusStringUpdate(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block16: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ? where id = ?");
                baos = new ByteArrayOutputStream();
                oout = new ObjectOutputStream(baos);
                oout.writeObject(statusString);
                byte[] b = baos.toByteArray();
                statement.setBytes(1, b);
                statement.setTimestamp(2, updatets);
                statement.setLong(3, key);
                statement.executeUpdate();
                if (baos == null) break block16;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    private void executeExecutionDataUpdate(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String status, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            oout.reset();
            oout.writeObject(status);
            b = baos.toByteArray();
            statement.setBytes(7, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private void executeDelete(Object key, String query) {
        logger.entering(CLASSNAME, "executeDelete", new Object[]{key, query});
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setObject(1, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeDelete");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> List<T> executeQuery(Object key, String query) {
        ArrayList<Object> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            logger.entering(CLASSNAME, "executeQuery", new Object[]{key, query});
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<Object>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(query);
                statement.setObject(1, key);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    Object deSerializedObject = objectIn.readObject();
                    data.add(deSerializedObject);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "executeQuery");
        return data;
    }

    private List<Long> executeIDQuery(Object key, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    private Set<String> executeNameQuery(String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<String> data = new HashSet<String>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                data.add(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    private void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, rs, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }

    @Override
    public void jobOperatorCreateJobInstanceData(long key, String Value) {
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        List data = this.executeQuery(jobName, SELECT_JOBINSTANCEDATA_COUNT);
        if (data != null && !data.isEmpty()) {
            return (Integer)data.get(0);
        }
        return 0;
    }

    @Override
    public List<Long> jobOperatorgetJobInstanceIds(String jobName, int start, int count) {
        List<Long> data = this.executeIDQuery(jobName, SELECT_JOBINSTANCEDATA_IDS);
        return data.subList(start, start + count);
    }

    @Override
    public Set<String> jobOperatorgetJobNames() {
        Set<String> data = this.executeNameQuery(SELECT_JOBINSTANCEDATA_NAMES);
        return data;
    }

    @Override
    public void jobOperatorCreateExecutionData(long key, Timestamp createTime, Timestamp starttime, Timestamp endtime, Timestamp updateTime, Properties parms, long instanceID, String batchstatus, String exitstatus) {
        this.executeExecutionDataInsert(key, createTime, starttime, endtime, updateTime, parms, instanceID, batchstatus, exitstatus, INSERT_EXECUTIONDATA);
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, String requestedTimestamp) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp timestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedTimestamp + " from executioninstancedata where id = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                timestamp = rs.getTimestamp(requestedTimestamp);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String jobOperatorQueryJobExecutionStatus(long key, String requestedStatus) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ObjectInputStream objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedStatus + " from executioninstancedata where id = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                byte[] buf = rs.getBytes(requestedStatus);
                if (buf != null) {
                    objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                }
                String status = (String)objectIn.readObject();
            }
            this.cleanupConnection(conn, rs, statement);
            return "FIGURING OUT HOW TO GET A STRING FROM A BLOB";
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
            catch (IOException e2) {
                e2.printStackTrace();
                return "FIGURING OUT HOW TO GET A STRING FROM A BLOB";
            }
            catch (ClassNotFoundException e3) {
                e3.printStackTrace();
                return "FIGURING OUT HOW TO GET A STRING FROM A BLOB";
            }
        }
        finally {
            this.cleanupConnection(conn, rs, statement);
        }
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where id = ?");
            statement.setLong(1, executionID);
            rs = statement.executeQuery();
            while (rs.next()) {
                jobinstanceID = rs.getLong("jobinstanceid");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobinstanceID;
    }

    @Override
    public void stepExecutionCreateStepExecutionData(String stepExecutionKey, long jobExecutionID, long stepExecutionID) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("insert into stepexecutionInstanceData values(?, ?, ?)");
            statement.setString(1, stepExecutionKey);
            statement.setLong(2, jobExecutionID);
            statement.setLong(3, stepExecutionID);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, rs, statement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution> stepExecutionQueryIDList(long key, String idtype) {
        ArrayList<StepExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block10: {
            conn = null;
            statement = null;
            rs = null;
            long jobexecid = 0L;
            long stepexecid = 0L;
            data = new ArrayList<StepExecution>();
            StepExecutionImpl stepEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select jobexecid, stepexecid from stepexecutioninstancedata where " + idtype + " = ?");
                statement.setLong(1, key);
                rs = statement.executeQuery();
                while (rs.next()) {
                    jobexecid = rs.getLong(JOBEXEC_ID);
                    stepexecid = rs.getLong(STEPEXEC_ID);
                    stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    data.add(stepEx);
                }
                if (objectIn == null) break block10;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    @Override
    public long stepExecutionQueryID(String key, String idtype) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long id = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + idtype + " from stepexecutioninstancedata where id = " + key);
            rs = statement.executeQuery();
            while (rs.next()) {
                id = rs.getLong(idtype);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return id;
    }
}

