/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterRead;
import javax.batch.annotation.BeforeRead;
import javax.batch.annotation.OnReadError;
import jsr352.batch.jsl.Property;

public class ItemReadListenerProxy
extends AbstractProxy {
    private Method beforeReadMethod = null;
    private Method afterReadMethod = null;
    private Method onReadErrorMethod = null;

    ItemReadListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            OnReadError onReadError;
            AfterRead afterRead;
            BeforeRead beforeRead = method.getAnnotation(BeforeRead.class);
            if (beforeRead != null) {
                this.beforeReadMethod = method;
            }
            if ((afterRead = method.getAnnotation(AfterRead.class)) != null) {
                this.afterReadMethod = method;
            }
            if ((onReadError = method.getAnnotation(OnReadError.class)) == null) continue;
            this.onReadErrorMethod = method;
        }
    }

    public void beforeRead() {
        if (this.beforeReadMethod != null) {
            try {
                this.beforeReadMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterRead() {
        if (this.afterReadMethod != null) {
            try {
                this.afterReadMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onReadError() {
        if (this.onReadErrorMethod != null) {
            try {
                this.onReadErrorMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

