/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.BaseTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public abstract class ConditionalTagHandler
extends BaseTagHandler {
    private static final Probe PROBE = ProbeFactory.getProbe();
    public static final long NOT_COMPARABLE = Long.MIN_VALUE;
    private static final String DATE_MASK = "yyyy/MM/dd hh:mm:ss";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
    private static final String START_INDEX = "[";
    private static final String END_INDEX = "]";
    private static final String EMPTY_INDEX = "[]";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public abstract boolean isCondition(SqlTagContext var1, SqlTag var2, Object var3);

    public int doStartFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        ctx.pushRemoveFirstPrependMarker(tag);
        if (this.isCondition(ctx, tag, parameterObject)) {
            return 1;
        }
        return 0;
    }

    public int doEndFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuffer bodyContent) {
        IterateContext iterate = ctx.peekIterateContext();
        if (null != iterate && iterate.isAllowNext()) {
            iterate.next();
            iterate.setAllowNext(false);
            if (!iterate.hasNext()) {
                iterate.setFinal(true);
            }
        }
        return super.doEndFragment(ctx, tag, parameterObject, bodyContent);
    }

    protected long compare(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        Class type;
        Object value1;
        String propertyName = tag.getPropertyAttr();
        String comparePropertyName = tag.getComparePropertyAttr();
        String compareValue = tag.getCompareValueAttr();
        String prop = tag.getPropertyAttr();
        IterateContext itCtx = ctx.peekIterateContext();
        if (prop != null) {
            if (null != itCtx && itCtx.isAllowNext()) {
                itCtx.next();
                itCtx.setAllowNext(false);
                if (!itCtx.hasNext()) {
                    itCtx.setFinal(true);
                }
            }
            if (prop.indexOf(START_INDEX) > -1) {
                propertyName = new StringBuffer(propertyName).insert(propertyName.indexOf(END_INDEX), itCtx.getIndex()).toString();
            }
            value1 = PROBE.getObject(parameterObject, propertyName);
            type = PROBE.getPropertyTypeForGetter(parameterObject, propertyName);
        } else {
            value1 = parameterObject;
            if (value1 != null) {
                type = parameterObject.getClass();
            } else {
                Class clazz = type = class$java$lang$Object == null ? (class$java$lang$Object = ConditionalTagHandler.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }
        if (comparePropertyName != null) {
            Object value2 = PROBE.getObject(parameterObject, comparePropertyName);
            return this.compareValues(type, value1, value2);
        }
        if (compareValue != null) {
            return this.compareValues(type, value1, compareValue);
        }
        throw new NestedRuntimeException("Error comparing in conditional fragment.  Uknown 'compare to' values.");
    }

    protected long compareValues(Class type, Object value1, Object value2) {
        long result = Long.MIN_VALUE;
        if (value1 == null || value2 == null) {
            result = value1 == value2 ? 0L : Long.MIN_VALUE;
        } else {
            if (value2.getClass() != type) {
                value2 = this.convertValue(type, value2.toString());
            }
            if (value2 instanceof String && type != (class$java$lang$String == null ? (class$java$lang$String = ConditionalTagHandler.class$("java.lang.String")) : class$java$lang$String)) {
                value1 = value1.toString();
            }
            if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                value1 = value1.toString();
                value2 = value2.toString();
            }
            result = ((Comparable)value1).compareTo(value2);
        }
        return result;
    }

    protected Object convertValue(Class type, String value) {
        if (type == (class$java$lang$String == null ? (class$java$lang$String = ConditionalTagHandler.class$("java.lang.String")) : class$java$lang$String)) {
            return value;
        }
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConditionalTagHandler.class$("java.lang.Byte")) : class$java$lang$Byte) || type == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = ConditionalTagHandler.class$("java.lang.Short")) : class$java$lang$Short) || type == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (type == (class$java$lang$Character == null ? (class$java$lang$Character = ConditionalTagHandler.class$("java.lang.Character")) : class$java$lang$Character) || type == Character.TYPE) {
            return new Character(value.charAt(0));
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConditionalTagHandler.class$("java.lang.Integer")) : class$java$lang$Integer) || type == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = ConditionalTagHandler.class$("java.lang.Long")) : class$java$lang$Long) || type == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = ConditionalTagHandler.class$("java.lang.Float")) : class$java$lang$Float) || type == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = ConditionalTagHandler.class$("java.lang.Double")) : class$java$lang$Double) || type == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConditionalTagHandler.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (type == (class$java$util$Date == null ? (class$java$util$Date = ConditionalTagHandler.class$("java.util.Date")) : class$java$util$Date)) {
            try {
                return DATE_FORMAT.parse(value);
            }
            catch (ParseException e) {
                throw new NestedRuntimeException("Error parsing date.  Cause: " + e, (Throwable)e);
            }
        }
        if (type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConditionalTagHandler.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(value);
        }
        if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConditionalTagHandler.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(value);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

