/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.jta;

import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.sqlmap.engine.transaction.IsolationLevel;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JtaTransaction
implements Transaction {
    private static final Log connectionLog = LogFactory.getLog((Class)(class$java$sql$Connection == null ? (class$java$sql$Connection = JtaTransaction.class$("java.sql.Connection")) : class$java$sql$Connection));
    private UserTransaction userTransaction;
    private DataSource dataSource;
    private Connection connection;
    private IsolationLevel isolationLevel = new IsolationLevel();
    private boolean commmitted = false;
    private boolean newTransaction = false;
    static /* synthetic */ Class class$java$sql$Connection;

    public JtaTransaction(UserTransaction utx, DataSource ds, int isolationLevel) throws TransactionException {
        this.userTransaction = utx;
        this.dataSource = ds;
        if (this.userTransaction == null) {
            throw new TransactionException("JtaTransaction initialization failed.  UserTransaction was null.");
        }
        if (this.dataSource == null) {
            throw new TransactionException("JtaTransaction initialization failed.  DataSource was null.");
        }
        this.isolationLevel.setIsolationLevel(isolationLevel);
    }

    private void init() throws TransactionException, SQLException {
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JtaTransaction could not start transaction.  Cause: ", e);
        }
        this.connection = this.dataSource.getConnection();
        if (this.connection == null) {
            throw new TransactionException("JtaTransaction could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        this.isolationLevel.applyIsolationLevel(this.connection);
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        if (connectionLog.isDebugEnabled()) {
            this.connection = ConnectionLogProxy.newInstance((Connection)this.connection);
        }
    }

    public void commit() throws SQLException, TransactionException {
        if (this.connection != null) {
            if (this.commmitted) {
                throw new TransactionException("JtaTransaction could not commit because this transaction has already been committed.");
            }
            try {
                if (this.newTransaction) {
                    this.userTransaction.commit();
                }
            }
            catch (Exception e) {
                throw new TransactionException("JtaTransaction could not commit.  Cause: ", e);
            }
            this.commmitted = true;
        }
    }

    public void rollback() throws SQLException, TransactionException {
        if (this.connection != null && !this.commmitted) {
            try {
                if (this.userTransaction != null) {
                    if (this.newTransaction) {
                        this.userTransaction.rollback();
                    } else {
                        this.userTransaction.setRollbackOnly();
                    }
                }
            }
            catch (Exception e) {
                throw new TransactionException("JtaTransaction could not rollback.  Cause: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException, TransactionException {
        if (this.connection != null) {
            try {
                this.isolationLevel.restoreIsolationLevel(this.connection);
            }
            finally {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    public Connection getConnection() throws SQLException, TransactionException {
        if (this.connection == null) {
            this.init();
        }
        return this.connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

