/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IterateContext
implements Iterator {
    private Iterator iterator;
    private int index = -1;
    private String property;
    private boolean allowNext = true;
    private SqlTag tag;

    public IterateContext(Object collection, SqlTag tag) {
        this.tag = tag;
        if (collection instanceof Collection) {
            this.iterator = ((Collection)collection).iterator();
        } else if (collection instanceof Iterator) {
            this.iterator = (Iterator)collection;
        } else if (collection.getClass().isArray()) {
            List list = this.arrayToList(collection);
            this.iterator = list.iterator();
        } else {
            throw new SqlMapException("ParameterObject or property was not a Collection, Array or Iterator.");
        }
    }

    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    public Object next() {
        ++this.index;
        return this.iterator.next();
    }

    public void remove() {
        this.iterator.remove();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.iterator != null && !this.iterator.hasNext();
    }

    private List arrayToList(Object array) {
        List<Object> list = null;
        if (array instanceof Object[]) {
            list = Arrays.asList((Object[])array);
        } else {
            list = new ArrayList<Object>();
            int n = Array.getLength(array);
            for (int i = 0; i < n; ++i) {
                list.add(Array.get(array, i));
            }
        }
        return list;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isAllowNext() {
        return this.allowNext;
    }

    public void setAllowNext(boolean performIterate) {
        this.allowNext = performIterate;
    }

    public SqlTag getTag() {
        return this.tag;
    }

    public void setTag(SqlTag tag) {
        this.tag = tag;
    }
}

