/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic;

import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlChild;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.mapping.statement.GeneralStatement;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DynamicSql
implements Sql,
DynamicParent {
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();
    private List children = new ArrayList();
    private SqlMapExecutorDelegate delegate;

    public DynamicSql(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public String getSql(RequestScope request, Object parameterObject) {
        String sql = request.getDynamicSql();
        if (sql == null) {
            this.process(request, parameterObject);
            sql = request.getDynamicSql();
        }
        return sql;
    }

    public ParameterMap getParameterMap(RequestScope request, Object parameterObject) {
        ParameterMap map = request.getDynamicParameterMap();
        if (map == null) {
            this.process(request, parameterObject);
            map = request.getDynamicParameterMap();
        }
        return map;
    }

    public ResultMap getResultMap(RequestScope request, Object parameterObject) {
        return request.getResultMap();
    }

    public void cleanup(RequestScope request) {
        request.setDynamicSql(null);
        request.setDynamicParameterMap(null);
    }

    private void process(RequestScope request, Object parameterObject) {
        SqlTagContext ctx = new SqlTagContext();
        List localChildren = this.children;
        this.processBodyChildren(request, ctx, parameterObject, localChildren.iterator());
        BasicParameterMap map = new BasicParameterMap(this.delegate);
        map.setId(request.getStatement().getId() + "-InlineParameterMap");
        map.setParameterClass(((GeneralStatement)request.getStatement()).getParameterClass());
        map.setParameterMappingList(ctx.getParameterMappings());
        String dynSql = ctx.getBodyText();
        if (SimpleDynamicSql.isSimpleDynamicSql(dynSql)) {
            dynSql = new SimpleDynamicSql(this.delegate, dynSql).getSql(request, parameterObject);
        }
        request.setDynamicSql(dynSql);
        request.setDynamicParameterMap(map);
    }

    private void processBodyChildren(RequestScope request, SqlTagContext ctx, Object parameterObject, Iterator localChildren) {
        PrintWriter out = ctx.getWriter();
        this.processBodyChildren(request, ctx, parameterObject, localChildren, out);
    }

    private void processBodyChildren(RequestScope request, SqlTagContext ctx, Object parameterObject, Iterator localChildren, PrintWriter out) {
        while (localChildren.hasNext()) {
            SqlChild child = (SqlChild)localChildren.next();
            if (child instanceof SqlText) {
                SqlText sqlText = (SqlText)child;
                String sqlStatement = sqlText.getText();
                if (sqlText.isWhiteSpace()) {
                    out.print(sqlStatement);
                    continue;
                }
                out.print(sqlStatement);
                ParameterMapping[] mappings = sqlText.getParameterMappings();
                if (mappings == null) continue;
                int n = mappings.length;
                for (int i = 0; i < n; ++i) {
                    ctx.addParameterMapping(mappings[i]);
                }
                continue;
            }
            if (!(child instanceof SqlTag)) continue;
            SqlTag tag = (SqlTag)child;
            SqlTagHandler handler = tag.getHandler();
            int response = 1;
            do {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                response = handler.doStartFragment(ctx, tag, parameterObject);
                if (response == 0) continue;
                this.processBodyChildren(request, ctx, parameterObject, tag.getChildren(), pw);
                pw.flush();
                pw.close();
                StringBuffer body = sw.getBuffer();
                response = handler.doEndFragment(ctx, tag, parameterObject, body);
                handler.doPrepend(ctx, tag, parameterObject, body);
                if (response == 0 || body.length() <= 0) continue;
                if (tag.isPostParseRequired()) {
                    SqlText sqlText = PARAM_PARSER.parseInlineParameterMap(this.delegate.getTypeHandlerFactory(), body.toString());
                    out.print(sqlText.getText());
                    ParameterMapping[] mappings = sqlText.getParameterMappings();
                    if (mappings == null) continue;
                    int n = mappings.length;
                    for (int i = 0; i < n; ++i) {
                        ctx.addParameterMapping(mappings[i]);
                    }
                } else {
                    out.print(body.toString());
                }
            } while (response == 2);
            ctx.popRemoveFirstPrependMarker(tag);
            if (ctx.peekIterateContext() == null || ctx.peekIterateContext().getTag() != tag) continue;
            ctx.popIterateContext();
        }
    }

    public void addChild(SqlChild child) {
        this.children.add(child);
    }
}

